package com.bxm.shopping.integration.jizhengyun.model;

import java.text.SimpleDateFormat;
import java.util.Date;

public class SerialNumberUtil {

	/**
	 * 生成订单号
	 * 
	 * @author zhb
	 * @version V001Z0001
	 * @date 2016-10-30
	 * @see [相关类/方法]
	 * @since [产品/模块版本]
	 */
	/**
	 * 获取现在时间
	 * 
	 * @return返回字符串格式yyyyMMddHHmmss
	 */
	public static String getStringDate() {
		Date currentTime = new Date();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
		String dateString = formatter.format(currentTime);
		System.out.println("TIME:::" + dateString);
		return dateString;
	}

	/**
	 * 由年月日时分秒+3位随机数 生成流水号
	 * 
	 * @return
	 */
	public static String createBillNo() {
		String t = getStringDate();
		return t + generateRandomNumber(4);
	}

    /**
     * 产生n位随机数
     *
     * @param n
     * @return long
     * @throws
     * @author kk.xie
     * @date 2018/7/24 11:56
     */
    private static long generateRandomNumber(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("随机数位数必须大于0");
        }
        return (long) (Math.random() * 9 * Math.pow(10, n - 1)) + (long) Math.pow(10, n - 1);
    }
}
