package com.bxm.shopping.integration.kuaidi;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.kuaidi.config.CallbackConfig;
import com.bxm.shopping.integration.kuaidi.contant.ApiInfoConstant;
import com.bxm.shopping.integration.kuaidi.model.*;
import com.bxm.shopping.integration.kuaidi.utils.HttpUtils;
import com.bxm.shopping.integration.kuaidi.utils.SignUtils;
import com.bxm.warcar.utils.JsonHelper;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.*;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * 快递100接口
 * @author tangx
 * @date 2020/8/20 10:39
 */
@Slf4j
@Configuration
public class KuaidiIntegration {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private CallbackConfig callbackConfig;

    private final static String KEY = "Eoewtnku9597";
    private final static String CUSTOMER = "39D4EB0FA0CA33A4E699D3AEA10CDF99";

    /**
     * 盐值
     */
    public final static String SALT = "bxm";

    public SubscribeResp subscribeOrder(String number, String company, String orderNum) {
        String callbackUrl = callbackConfig.getUrl();
        SubscribeResp subscribe = new SubscribeResp();
        if (StringUtils.isBlank(callbackUrl)) {
            log.error("未配置快递100订阅回调接口！");
            return subscribe;
        }

        SubscribeReq subscribeReq = new SubscribeReq();
        subscribeReq.setSchema(ApiInfoConstant.SUBSCRIBE_SCHEMA);
        SubscribeParam subscribeParam = new SubscribeParam();
        SubscribeParameters subscribeParameters = new SubscribeParameters();
        subscribeParameters.setCallbackurl(callbackUrl + "?orderNum=" + orderNum + "&trackingNum=" + number);
        subscribeParameters.setSalt(SALT);
        subscribeParam.setParameters(subscribeParameters);
        subscribeParam.setCompany(company);
        subscribeParam.setNumber(number);
        subscribeParam.setKey(KEY);
        subscribeReq.setParam(subscribeParam);
        try {
            subscribe = subscribe(subscribeReq);
        } catch (Exception e) {
            log.error("调用kuaidi100订阅接口出错", e);
        }
        return subscribe;
    }

    /**
     * 查询物流信息
     * @param trackingNum
     * @param company
     * @return
     */
    public QueryTrackResp queryTrack(String trackingNum, String company) {
        QueryTrackReq queryTrackReq = new QueryTrackReq();
        QueryTrackParam queryTrackParam = new QueryTrackParam();
        queryTrackParam.setCom(company);
        queryTrackParam.setNum(trackingNum);
        queryTrackReq.setParam(queryTrackParam);
        queryTrackReq.setCustomer(CUSTOMER);
        queryTrackReq.setSign(SignUtils.sign(new Gson().toJson(queryTrackParam)+ KEY + CUSTOMER));

        QueryTrackResp queryTrackResp = new QueryTrackResp();

        HttpResult httpResult = HttpUtils.doPost(ApiInfoConstant.QUERY_URL, queryTrackReq);

        if (httpResult.getStatus() == HttpStatus.OK.value() && StringUtils.isNotBlank(httpResult.getBody())){
            queryTrackResp = new Gson().fromJson(httpResult.getBody(),QueryTrackResp.class);
        }
        return queryTrackResp;
    }

    /**
     * 订阅接口
     *
     * @param subscribeReq
     * @return
     */
    public SubscribeResp subscribe(SubscribeReq subscribeReq) throws IllegalAccessException {

        MultiValueMap<String, String> params = HttpUtils.objectToMultiValueMap(subscribeReq);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType("application/x-www-form-urlencoded; charset=UTF-8"));
        JSONObject postParameters = new JSONObject();
        postParameters.put("param", subscribeReq);
        HttpEntity subscribeRespHttpEntity = new HttpEntity(params, headers);

        ResponseEntity<String> responseEntity = restTemplate.postForEntity(ApiInfoConstant.SUBSCRIBE_URL, subscribeRespHttpEntity, String.class);

        SubscribeResp subscribeResp = new SubscribeResp();
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && StringUtils.isNotBlank(responseEntity.getBody())) {
            subscribeResp = JsonHelper.convert(responseEntity.getBody(), SubscribeResp.class);
        }
        return subscribeResp;
    }


}
