package com.bxm.shopping.integration.liantong;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.integration.liantong.model.ReqHeadBean;
import com.bxm.shopping.integration.liantong.model.ReqObj;
import com.bxm.shopping.integration.liantong.model.SecurityTool;
import com.bxm.shopping.integration.liantong.model.SendCaptchaBody;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import java.util.UUID;

/**
 * @author tangx
 * @date 2021/9/11 9:39
 */
@Slf4j
@Configuration
public class LianTongCaptchaIntegration {

    public static final String LINK1 = "/link/king/card/message/send/v2";
    public static final String LINK2 = "/link/king/card/message/check/v2";
    private static final String CHANNEL = "08-2278-a3zb-a4n0";
    private static final String SUCCESS_CODE = "0000";
    private final static String CODE_IDCARD_VERIFY = "C001";
    // 测试
//    private static final String APP_CODE = "B1335C552F574C69B618F4DEE661D61D";
//    private static final String URL = "http://123.125.96.156/zop/";
//    private static final String AES = "2D/52zYR3Ve2FusrDxGdHw==";
//    private static final String HMAC = "vi0scikzZxOkJ7i/0uNiI4xvFAQsbUQnlp20GpSGIM6QqnHB0Vw8Yjw32tCPwRSNBsZEM6B6DPTft2fwVqAY5w==";

    // 生产
    private static final String APP_CODE = "CDA1B8024E794A16A165B3CD0DB0921F";
    private static final String URL = "http://123.125.96.156/zop/";
    private static final String AES = "uRkCSN8eAi1jEFvUmfWF1Q==";
    private static final String HMAC = "YFkl81Kl7ZS8C9szVrl8jCU4yN7yPZZ0bF9qrz6F3B5IMQmbxvozFFMfkwyM5veu2xZPDnuaz1/FGnWxQE0RHA==";


    @Autowired
    private RestTemplate restTemplate;

    public static void main(String[] args) throws Exception {
        LianTongCaptchaIntegration integration = new LianTongCaptchaIntegration();
        integration.send("43062119961003041X", "13296731087");
//        integration.verifyCaptcha("674992");
    }

    public void send(String idCard, String mobile) {
        Preconditions.checkArgument(StringUtils.isNotBlank(idCard), "请填写身份证");
        Preconditions.checkArgument(StringUtils.isNotBlank(mobile), "请填写手机号");
        try {
            log.info("请求联通发送验证码接口 mobile:{} idCard:{}", mobile, idCard);
            doRequest(idCard, mobile, null);
        } catch (ShoppingException e) {
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ShoppingException("请求验证码异常");
        }
    }


    public boolean verifyCaptcha(String idCard, String mobile, String captcha) {
        Preconditions.checkArgument(StringUtils.isNotBlank(idCard), "请填写身份证");
        Preconditions.checkArgument(StringUtils.isNotBlank(mobile), "请填写手机号");
        Preconditions.checkArgument(StringUtils.isNotBlank(captcha), "请填写验证码");
        try {
            log.info("请求联通检测验证码接口 mobile:{} idCard:{} captcha:{}", mobile, idCard, captcha);

            doRequest(idCard, mobile, captcha);
        } catch (ShoppingException e) {
            throw e;
        } catch (Exception e) {
            throw new ShoppingException("验证异常");
        }
        return true;

    }

    private void doRequest(String idCard, String mobile, String captcha)  throws Exception{
        String uuid = String.valueOf(UUID.randomUUID());
        JSONObject baseReq = new JSONObject();
        baseReq.put("appCode", APP_CODE);
        ReqObj obj = new ReqObj();
        ReqHeadBean head = new ReqHeadBean();
        head.setTimestamp(new DateTime().toString("yyyy-MM-dd HH:mm:ss.SSS"));
        head.setUuid(uuid);

        head.setSign(makeSign(head, APP_CODE));
        obj.setHead(head);

        SendCaptchaBody body = new SendCaptchaBody();
        body.setCertId(idCard);
        body.setChannel(CHANNEL);
        body.setContactNum(mobile);
        body.setCaptcha(captcha);

        obj.setBody(body);
        //reOjb不需要加密时
        //baseReq.put("reqObj",obj);
        //reqObj节点需要加密时
        baseReq.put("reqObj", SecurityTool.encrypt(AES, JSONObject.toJSONString(obj)));
        String myUrl;
        if (StringUtils.isNotBlank(captcha) ) {
            myUrl = URL + LINK2 + "?uuid=" + uuid;
        } else {
            myUrl = URL + LINK1 + "?uuid=" + uuid;
        }

        log.info("请求联通报文：" + JSONObject.toJSONString(baseReq));

        String response = restTemplate.postForObject(myUrl, JSONObject.toJSONString(baseReq), String.class);
        log.info("联通接口响应：{}, idCard:{}, mobile:{}, captcha:{}", response, idCard, mobile, captcha);

        JSONObject responseJSON = JSONObject.parseObject(response, JSONObject.class);
        String rspCode = responseJSON.getString("rspCode");
        String rspDesc = responseJSON.getString("rspDesc");
        if (!SUCCESS_CODE.equals(rspCode)) {
            if (CODE_IDCARD_VERIFY.equals(rspCode)) {
                throw new ShoppingException("身份证号或手机号填写错误，请检查。");
            }
            throw new ShoppingException(rspDesc);
        }
    }

    private String makeSign(ReqHeadBean req, String appCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        //appCode+head节点（除sign节点,字母升序）+hmac密钥
        sb.append("appCode").append(appCode)
                .append("timestamp").append(req.getTimestamp())
                .append("uuid").append(req.getUuid())
                .append(HMAC);
        return SecurityTool.sign(HMAC, sb.toString());
    }
}
