package com.bxm.shopping.integration.pay;

import com.bxm.pay.facade.PayService;
import com.bxm.pay.facade.model.Order;
import com.bxm.pay.facade.model.RefundResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangx
 * @date 2019/10/21 10:07
 */
@Slf4j
@Configuration
public class PayFacadeIntegration {

    @Autowired
    private PayService payService;

    public String pay(Order order){
        return payService.pay(order);
    }

    public Boolean refund(Order order){
        RefundResult refund = payService.refund(order);
        log.info("orderNo:{} pay service refund resultMsg:{}", order.getOrderNum(), refund.getMsg());
        if (RefundResult.SUCCESS.equals(refund.getCode())){
            return true;
        }
        return false;
    }


}
