package com.bxm.shopping.integration.pushable;

import com.bxm.shopping.facade.constant.pushable.CachePushableServiceEnum;
import com.bxm.warcar.integration.pushable.CachePushableService;
import com.bxm.warcar.integration.pushable.message.MessageEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 推送数据到前端<br/>
 * 将数据推送到<code>serviceName</code>服务，对应的服务接收到请求后<br/>
 * 根据<code>parameters</code>参数约定来生成缓存的KEY，<br/>
 * 最后将<code>data</code>数据更新到响应的缓存中。
 *
 * @author kerry.jiang
 * @date 2019/12/26 15:22
 */
@Slf4j
@Service
public class CachePushableIntegration {

    private final CachePushableService cachePushableService;

    public CachePushableIntegration(CachePushableService cachePushableService) {
        this.cachePushableService = cachePushableService;
    }

    /**
     * 统一推送数据
     */
    public String push(CachePushableServiceEnum service, byte[] data, Map<String, Object> parameters) throws Exception {
        MessageEntity entity = new MessageEntity(service.getName(), parameters, data);
        return cachePushableService.push(entity, service.getTopic());
    }
}
