package com.bxm.shopping.integration.wechat;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.exception.WeixinException;
import com.bxm.shopping.integration.wechat.config.WechatConfig;
import com.bxm.shopping.integration.wechat.model.SnsAccessToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * @author tangx
 * @date 2019/11/11 11:38
 */
@Configuration
@Slf4j
public class WechatAuthIntegration extends WeixinSupport{

    @Autowired
    private WechatConfig wechatConfig;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 获取微信用户OpenId
     * @param code
     * @return
     * @throws WeixinException
     */
    public String getOpenId(String code) throws WeixinException {
        SnsAccessToken snsOAuth2AccessToken = getSnsOAuth2AccessToken(code);
        return snsOAuth2AccessToken.getOpenid();
    }

    /**
     * 获取网页授权AccessToken
     * @param code
     * @return
     * @throws WeixinException
     */
    public SnsAccessToken getSnsOAuth2AccessToken(String code) throws WeixinException{
        if (StringUtils.isEmpty(code)) {
            throw new IllegalArgumentException("code can't be null or empty");
        }
        //拼接参数
        String param = "?appid=" + wechatConfig.getAppId() + "&secret=" + wechatConfig.getSecret() + "&code=" + code + "&grant_type=authorization_code";
        //创建请求对象
        //调用获取access_token接口
        String jsonStr = restTemplate.getForObject(wechatConfig.getAccessTokenUrl() + param, String.class);
        //根据请求结果判定，是否验证成功
        JSONObject jsonObj = JSONObject.parseObject(jsonStr);
        if (jsonObj == null) {
            return null;
        }

        Object errcode = jsonObj.get("errcode");
        if (errcode != null) {
            //返回异常信息
            throw new WeixinException(getCause(jsonObj.getIntValue("errcode")));
        }
        return new SnsAccessToken(jsonObj);
    }


}
