package com.bxm.shopping.integration.wechat.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author tangx
 * @date 2019/11/12 10:56
 */

@ConfigurationProperties(prefix = "wechat.config")
@Component
public class WechatConfig {

    // 丰诺
    private String appId;
    private String secret;

    // 变现猫
//    private String appId = "wx15d238f7f984a6b6";
//    private String secret = "83c4775a89605754016082dae81401bd";

    private String accessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token";

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getAccessTokenUrl() {
        return accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }
}
