/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.ApiSendException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ChkRiskIntegration {
    private static final Logger log = LoggerFactory.getLogger(ChkRiskIntegration.class);
    @Autowired
    @Qualifier(value="orderRestTemplate")
    private RestTemplate restTemplate;
    public static final String requestUrl = "http://lxk.pancou.com:8008/card/szunicom/v2/chkRisk?appCode=4894";
    public static final String userId = "8";

    public static void main(String[] args) {
        ChkRiskIntegration chkRiskIntegration = new ChkRiskIntegration();
    }

    public void send(RequestObject requestObject) {
        this.processRequest(requestObject);
    }

    private void processRequest(RequestObject requestObject) {
        HttpEntity httpEntity = this.buildHttpEntity(requestObject);
        JSONObject responseJson = (JSONObject)this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, JSONObject.class, new Object[0]).getBody();
        log.info("\u6c11\u6570api\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)responseJson));
        if (null != responseJson) {
            String code = Objects.toString(responseJson.get((Object)"code"));
            String msg = Objects.toString(responseJson.get((Object)"msg"));
            boolean success = StringUtils.equals((String)"0", (String)code);
            if (!success) {
                throw new ApiSendException(msg);
            }
        }
    }

    private HttpEntity buildHttpEntity(RequestObject requestObject) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        JSONObject param = new JSONObject();
        param.put("certName", (Object)requestObject.getCertName());
        param.put("certNo", (Object)requestObject.getCertNo());
        param.put("contactNum", (Object)requestObject.getContactNum());
        param.put("postCityCode", (Object)requestObject.getPostCityCode());
        param.put("postProvinceCode", (Object)requestObject.getPostProvinceCode());
        param.put("postDistrictCode", (Object)requestObject.getPostDistrictCode());
        param.put("userId", (Object)userId);
        param.put("address", (Object)requestObject.getAddress());
        log.info("\u6c11\u6570\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        HttpEntity httpEntity = new HttpEntity((Object)param.toString(), (MultiValueMap)headers);
        return httpEntity;
    }

    public static class RequestObject {
        private String certName;
        private String certNo;
        private String contactNum;
        private String postCityCode;
        private String postProvinceCode;
        private String postDistrictCode;
        private String address;

        public String getCertName() {
            return this.certName;
        }

        public String getCertNo() {
            return this.certNo;
        }

        public String getContactNum() {
            return this.contactNum;
        }

        public String getPostCityCode() {
            return this.postCityCode;
        }

        public String getPostProvinceCode() {
            return this.postProvinceCode;
        }

        public String getPostDistrictCode() {
            return this.postDistrictCode;
        }

        public String getAddress() {
            return this.address;
        }

        public void setCertName(String certName) {
            this.certName = certName;
        }

        public void setCertNo(String certNo) {
            this.certNo = certNo;
        }

        public void setContactNum(String contactNum) {
            this.contactNum = contactNum;
        }

        public void setPostCityCode(String postCityCode) {
            this.postCityCode = postCityCode;
        }

        public void setPostProvinceCode(String postProvinceCode) {
            this.postProvinceCode = postProvinceCode;
        }

        public void setPostDistrictCode(String postDistrictCode) {
            this.postDistrictCode = postDistrictCode;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestObject)) {
                return false;
            }
            RequestObject other = (RequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$certName = this.getCertName();
            String other$certName = other.getCertName();
            if (this$certName == null ? other$certName != null : !this$certName.equals(other$certName)) {
                return false;
            }
            String this$certNo = this.getCertNo();
            String other$certNo = other.getCertNo();
            if (this$certNo == null ? other$certNo != null : !this$certNo.equals(other$certNo)) {
                return false;
            }
            String this$contactNum = this.getContactNum();
            String other$contactNum = other.getContactNum();
            if (this$contactNum == null ? other$contactNum != null : !this$contactNum.equals(other$contactNum)) {
                return false;
            }
            String this$postCityCode = this.getPostCityCode();
            String other$postCityCode = other.getPostCityCode();
            if (this$postCityCode == null ? other$postCityCode != null : !this$postCityCode.equals(other$postCityCode)) {
                return false;
            }
            String this$postProvinceCode = this.getPostProvinceCode();
            String other$postProvinceCode = other.getPostProvinceCode();
            if (this$postProvinceCode == null ? other$postProvinceCode != null : !this$postProvinceCode.equals(other$postProvinceCode)) {
                return false;
            }
            String this$postDistrictCode = this.getPostDistrictCode();
            String other$postDistrictCode = other.getPostDistrictCode();
            if (this$postDistrictCode == null ? other$postDistrictCode != null : !this$postDistrictCode.equals(other$postDistrictCode)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $certName = this.getCertName();
            result = result * 59 + ($certName == null ? 43 : $certName.hashCode());
            String $certNo = this.getCertNo();
            result = result * 59 + ($certNo == null ? 43 : $certNo.hashCode());
            String $contactNum = this.getContactNum();
            result = result * 59 + ($contactNum == null ? 43 : $contactNum.hashCode());
            String $postCityCode = this.getPostCityCode();
            result = result * 59 + ($postCityCode == null ? 43 : $postCityCode.hashCode());
            String $postProvinceCode = this.getPostProvinceCode();
            result = result * 59 + ($postProvinceCode == null ? 43 : $postProvinceCode.hashCode());
            String $postDistrictCode = this.getPostDistrictCode();
            result = result * 59 + ($postDistrictCode == null ? 43 : $postDistrictCode.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        public String toString() {
            return "ChkRiskIntegration.RequestObject(certName=" + this.getCertName() + ", certNo=" + this.getCertNo() + ", contactNum=" + this.getContactNum() + ", postCityCode=" + this.getPostCityCode() + ", postProvinceCode=" + this.getPostProvinceCode() + ", postDistrictCode=" + this.getPostDistrictCode() + ", address=" + this.getAddress() + ")";
        }
    }
}

