/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.Liulv;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.ApiSendException;
import com.bxm.shopping.integration.Liulv.LiulvEntity;
import com.bxm.shopping.integration.Liulv.config.LiulvConfig;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class LiulvIntegration {
    private static final Logger log = LoggerFactory.getLogger(LiulvIntegration.class);
    private static final String APP_ID = "llbxm";
    private static final String VERSION = "1.0.0";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private LiulvConfig liulvConfig;

    public void send(LiulvEntity liulvEntity) {
        this.checkRequest(liulvEntity);
        this.processRequest(liulvEntity);
    }

    private void processRequest(LiulvEntity liulvEntity) {
        JSONObject responseJson;
        HttpEntity httpEntity = this.buildHttpEntity(liulvEntity);
        try {
            String requestUrl = this.liulvConfig.getRequestUrl();
            responseJson = (JSONObject)this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, JSONObject.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u516d\u5f8b\u53f7\u5361\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new ApiSendException("\u529e\u7406\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        log.info("\u516d\u5f8b\u53f7\u5361\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)responseJson));
        if (null != responseJson) {
            String code = (String)responseJson.get((Object)"code");
            String message = (String)responseJson.get((Object)"message");
            boolean success = StringUtils.equals((String)"200", (String)code);
            if (!success && StringUtils.isNotBlank((String)message)) {
                throw new ApiSendException(message);
            }
            return;
        }
        throw new ApiSendException("\u529e\u7406\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    private void checkRequest(LiulvEntity liulvEntity) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getUserMobile()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getUserName()), (Object)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getIdCard()), (Object)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getProvince()), (Object)"\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getCity()), (Object)"\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getRegion()), (Object)"\u533a\u53bf\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)liulvEntity.getAddress()), (Object)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private HttpEntity buildHttpEntity(LiulvEntity liulvEntity) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        JSONObject param = new JSONObject();
        JSONObject body = new JSONObject();
        JSONObject header = new JSONObject();
        header.put("appId", (Object)APP_ID);
        header.put("version", (Object)VERSION);
        header.put("requestId", (Object)UUIDHelper.generate());
        body.put("thirdOrderNo", (Object)liulvEntity.getOrderNum());
        body.put("addressPhone", (Object)liulvEntity.getUserMobile());
        body.put("userName", (Object)liulvEntity.getUserName());
        body.put("userCardNo", (Object)liulvEntity.getIdCard());
        body.put("province", (Object)liulvEntity.getProvince());
        body.put("city", (Object)liulvEntity.getCity());
        body.put("country", (Object)liulvEntity.getRegion());
        body.put("address", (Object)liulvEntity.getAddress());
        body.put("productId", (Object)liulvEntity.getProductExternalCode());
        param.put("header", (Object)header);
        param.put("body", (Object)body);
        log.info("\u516d\u5f8b\u53f7\u5361\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        HttpEntity httpEntity = new HttpEntity((Object)param.toString(), (MultiValueMap)headers);
        return httpEntity;
    }

    public static void main(String[] args) {
        System.out.println();
    }
}

