/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.ApiSendException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class Risk5243Checker {
    private static final Logger log = LoggerFactory.getLogger(Risk5243Checker.class);
    @Autowired
    @Qualifier(value="orderRestTemplate")
    private RestTemplate restTemplate = new RestTemplate();
    public static final String requestUrl = "https://api.hzylgs.com/java-api/h5api/unicomeRiskCheck";
    private static final String SUCCESS_CODE = "0000";

    public void send(RequestObject requestObject) {
        this.processRequest(requestObject);
    }

    private void processRequest(RequestObject requestObject) {
        HttpEntity httpEntity = this.buildHttpEntity(requestObject);
        JSONObject responseJson = (JSONObject)this.restTemplate.postForEntity(requestUrl, (Object)httpEntity, JSONObject.class, new Object[0]).getBody();
        log.info("risk5243 api\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString((Object)responseJson));
        if (null != responseJson) {
            String data = responseJson.getString("data");
            String desc = responseJson.getString("desc");
            boolean success = StringUtils.equals((String)SUCCESS_CODE, (String)data);
            if (!success) {
                if (StringUtils.isBlank((String)desc)) {
                    desc = CodeEnum.getDescByCode(data);
                }
                throw new ApiSendException(desc);
            }
        }
    }

    private HttpEntity buildHttpEntity(RequestObject requestObject) {
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        JSONObject param = new JSONObject();
        param.put("name", (Object)requestObject.getName());
        param.put("idCard", (Object)StringUtils.upperCase((String)requestObject.getIdCard()));
        param.put("mobile", (Object)requestObject.getMobile());
        param.put("province", (Object)requestObject.getProvince());
        param.put("city", (Object)requestObject.getCity());
        param.put("area", (Object)requestObject.getArea());
        param.put("address", (Object)requestObject.getAddress());
        log.info("risk5243 \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        HttpEntity httpEntity = new HttpEntity((Object)param.toString(), (MultiValueMap)headers);
        return httpEntity;
    }

    private static enum CodeEnum {
        _0001("0001", "\u59d3\u540d\u3001\u8054\u7cfb\u7535\u8bdd\u3001\u6536\u8d27\u5730\u5740\u8d85\u9650"),
        _0005("0005", "\u8bc1\u4ef6\u53f7\u8d85\u9650"),
        _0011("0011", "\u8054\u7cfb\u7535\u8bdd\u8d85\u9650"),
        _0013("0013", "\u4e00\u8bc1\u4e94\u6237\u8d85\u9650"),
        _0019("0019", "\u914d\u9001\u5730\u5740\u51b2\u7a81"),
        _0021("0021", "\u672a\u586b\u5199\u8be6\u7ec6\u5730\u5740"),
        _0025("0025", "\u6076\u610f\u5730\u5740"),
        _0026("0026", "\u5f85\u786e\u8ba4\u5730\u5740"),
        _0027("0027", "30\u5929\u5185\u540c\u4e00\u8bc1\u4ef6\u3001\u540c\u4e00\u8054\u7535\u3001\u540c\u4e00\u6536\u8d27\u5730\u5740\u4e0b\u5355\u8d85\u9650"),
        _0038("0038", "\u8bc1\u4ef690\u5929\u5185\u8ba2\u5355\u8d85\u8fc7\u9650\u5236"),
        _0041("0041", "\u5730\u5740\u4e0d\u5339\u914d");

        private String code;
        private String desc;

        public static String getDescByCode(String code) {
            if (StringUtils.isNotBlank((String)code)) {
                for (CodeEnum codeEnum : CodeEnum.values()) {
                    if (!Objects.equals(code, codeEnum.getCode())) continue;
                    return codeEnum.getDesc();
                }
            }
            return "\u8ba2\u5355\u9519\u8bef,\u6821\u9a8c\u672a\u901a\u8fc7";
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        private CodeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    public static class RequestObject {
        private String name;
        private String idCard;
        private String mobile;
        private String province;
        private String city;
        private String area;
        private String address;

        public static RequestObjectBuilder builder() {
            return new RequestObjectBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getIdCard() {
            return this.idCard;
        }

        public String getMobile() {
            return this.mobile;
        }

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public String getArea() {
            return this.area;
        }

        public String getAddress() {
            return this.address;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIdCard(String idCard) {
            this.idCard = idCard;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestObject)) {
                return false;
            }
            RequestObject other = (RequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$idCard = this.getIdCard();
            String other$idCard = other.getIdCard();
            if (this$idCard == null ? other$idCard != null : !this$idCard.equals(other$idCard)) {
                return false;
            }
            String this$mobile = this.getMobile();
            String other$mobile = other.getMobile();
            if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
                return false;
            }
            String this$province = this.getProvince();
            String other$province = other.getProvince();
            if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$area = this.getArea();
            String other$area = other.getArea();
            if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $idCard = this.getIdCard();
            result = result * 59 + ($idCard == null ? 43 : $idCard.hashCode());
            String $mobile = this.getMobile();
            result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
            String $province = this.getProvince();
            result = result * 59 + ($province == null ? 43 : $province.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $area = this.getArea();
            result = result * 59 + ($area == null ? 43 : $area.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        public String toString() {
            return "Risk5243Checker.RequestObject(name=" + this.getName() + ", idCard=" + this.getIdCard() + ", mobile=" + this.getMobile() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", area=" + this.getArea() + ", address=" + this.getAddress() + ")";
        }

        public RequestObject(String name, String idCard, String mobile, String province, String city, String area, String address) {
            this.name = name;
            this.idCard = idCard;
            this.mobile = mobile;
            this.province = province;
            this.city = city;
            this.area = area;
            this.address = address;
        }

        public static class RequestObjectBuilder {
            private String name;
            private String idCard;
            private String mobile;
            private String province;
            private String city;
            private String area;
            private String address;

            RequestObjectBuilder() {
            }

            public RequestObjectBuilder name(String name) {
                this.name = name;
                return this;
            }

            public RequestObjectBuilder idCard(String idCard) {
                this.idCard = idCard;
                return this;
            }

            public RequestObjectBuilder mobile(String mobile) {
                this.mobile = mobile;
                return this;
            }

            public RequestObjectBuilder province(String province) {
                this.province = province;
                return this;
            }

            public RequestObjectBuilder city(String city) {
                this.city = city;
                return this;
            }

            public RequestObjectBuilder area(String area) {
                this.area = area;
                return this;
            }

            public RequestObjectBuilder address(String address) {
                this.address = address;
                return this;
            }

            public RequestObject build() {
                return new RequestObject(this.name, this.idCard, this.mobile, this.province, this.city, this.area, this.address);
            }

            public String toString() {
                return "Risk5243Checker.RequestObject.RequestObjectBuilder(name=" + this.name + ", idCard=" + this.idCard + ", mobile=" + this.mobile + ", province=" + this.province + ", city=" + this.city + ", area=" + this.area + ", address=" + this.address + ")";
            }
        }
    }
}

