/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.adsmanager;

import com.bxm.adsmanager.facade.model.adTag.TblAdTagVo;
import com.bxm.adsmanager.facade.service.AdTagFacadeService;
import com.bxm.adsmanager.facade.service.RiskWordFacadeService;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdsmanagerIntegration {
    private static final Logger log = LoggerFactory.getLogger(AdsmanagerIntegration.class);
    @Autowired
    private RiskWordFacadeService riskWordFacadeService;
    @Autowired
    private AdTagFacadeService adTagFacadeService;

    public List<String> getRiskWord() {
        try {
            return this.riskWordFacadeService.getRiskWordList();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528adsmanager-web getRiskWordList \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public List<TblAdTagVo> getAdTag() {
        PageInfo returnValue;
        ResultModel newTreeAll = this.adTagFacadeService.findNewTreeAll(Integer.valueOf(0), Integer.valueOf(2), null, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        if (Objects.nonNull(newTreeAll) && Objects.nonNull(returnValue = (PageInfo)newTreeAll.getReturnValue())) {
            return returnValue.getList();
        }
        return Collections.EMPTY_LIST;
    }

    public List<TblAdTagVo> getAdTagAll() {
        PageInfo returnValue;
        ResultModel newAll = this.adTagFacadeService.findNewAll(Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), null, Integer.valueOf(2));
        if (Objects.nonNull(newAll) && Objects.nonNull(returnValue = (PageInfo)newAll.getReturnValue())) {
            return returnValue.getList();
        }
        return Collections.EMPTY_LIST;
    }

    public Map<Integer, String> getAdTagNameMap() {
        List<TblAdTagVo> adTagAll = this.getAdTagAll();
        if (CollectionUtils.isNotEmpty(adTagAll)) {
            Map<Integer, String> map = adTagAll.stream().collect(Collectors.toMap(t -> t.getCode(), t -> t.getName()));
            return map;
        }
        return Collections.EMPTY_MAP;
    }
}

