/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.adsmedia;

import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceUrlVO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.shopping.integration.adsmedia.AdsmediaFeignService;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdsmediaIntegration {
    private static final Logger log = LoggerFactory.getLogger(AdsmediaIntegration.class);
    @Autowired
    private AdsmediaFeignService adsmediaFeignService;
    public static final String CODE_NAME_FORMAT = "%06d";

    public AppEntranceAdRO findByPositionId(String positionId) {
        try {
            ResultModel<AppEntranceAdRO> resultModel = this.adsmediaFeignService.findByPositionId(positionId);
            if (resultModel.isSuccessed()) {
                return (AppEntranceAdRO)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public AppEntranceUrlVO getUrl(String positionId) {
        try {
            ResultModel<AppEntranceUrlVO> resultModel = this.adsmediaFeignService.getUrl(positionId);
            if (resultModel.isSuccessed()) {
                return (AppEntranceUrlVO)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u83b7\u53d6\u5e7f\u544a\u4f4d\u94fe\u63a5\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e7f\u544a\u4f4d\u94fe\u63a5\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public Map<String, String> getAppEntranceCodeName() {
        List<AppEntranceAdRO> appEntranceAdROS = this.getAllList(new QueryAppEntranceParamDTO());
        if (CollectionUtils.isEmpty(appEntranceAdROS)) {
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)appEntranceAdROS.size());
        for (AppEntranceAdRO appEntranceAdRO : appEntranceAdROS) {
            map.put(String.format(CODE_NAME_FORMAT, appEntranceAdRO.getCode()) + "-" + appEntranceAdRO.getAppEntranceId(), appEntranceAdRO.getPositionId());
        }
        return map;
    }

    public List<AppEntranceAdRO> getAllList(QueryAppEntranceParamDTO dto) {
        dto.setPageNum(dto.getPageNum());
        dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        return this.getPage(dto).getList();
    }

    public PageInfo<AppEntranceAdRO> getPage(QueryAppEntranceParamDTO dto) {
        try {
            ResultModel<PageInfo<AppEntranceAdRO>> resultModel = this.adsmediaFeignService.getPage(dto);
            if (resultModel.isSuccessed()) {
                return (PageInfo)resultModel.getReturnValue();
            }
            log.error("\u5f00\u53d1\u8005\u540e\u53f0\u5f02\u5e38\uff0c\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868\u5931\u8d25\uff01-->{},{}", (Object)resultModel.getErrorCode(), (Object)resultModel.getErrorDesc());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f00\u53d1\u8005\u540e\u53f0\u7684\u5e7f\u544a\u4f4d\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return AdsmediaIntegration.noneDataPage();
    }

    public static <T> PageInfo<T> noneDataPage() {
        PageInfo page = new PageInfo();
        page.setPageNum(1);
        page.setPageSize(20);
        page.setTotal(0L);
        page.setSize(0);
        page.setPages(0);
        page.setStartRow(0);
        page.setEndRow(0);
        page.setList(Collections.emptyList());
        page.setPrePage(0);
        page.setNextPage(0);
        page.setIsFirstPage(true);
        page.setIsLastPage(true);
        page.setHasPreviousPage(false);
        page.setHasNextPage(false);
        return page;
    }
}

