/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.advertiser;

import com.bxm.shopping.integration.advertiser.AdvertiserFeignService;
import com.bxm.shopping.integration.advertiser.model.Advertiser;
import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingDto;
import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdvertiserIntegration {
    @Autowired
    private AdvertiserFeignService advertiserFeignService;

    public AdvertiserShoppingVo merchantLogin(String userName, String password) {
        ResultModel<AdvertiserShoppingVo> resultModel = this.advertiserFeignService.merchantLogin(userName, password);
        if (resultModel == null || !resultModel.isSuccessed()) {
            return null;
        }
        AdvertiserShoppingVo vo = (AdvertiserShoppingVo)resultModel.getReturnValue();
        return vo;
    }

    public Advertiser getAdvertiserById(Integer advertiserId) {
        ResultModel<Advertiser> resultModel = this.advertiserFeignService.getById(advertiserId);
        if (resultModel == null || !resultModel.isSuccessed()) {
            return null;
        }
        Advertiser advertiser = (Advertiser)resultModel.getReturnValue();
        return advertiser;
    }

    public List<AdvertiserShoppingVo> getAdvertiserList(AdvertiserShoppingDto dto) {
        PageInfo<AdvertiserShoppingVo> pageInfo = this.advertiserFeignService.getList(dto);
        if (pageInfo == null) {
            return null;
        }
        return pageInfo.getList();
    }
}

