/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.jizhengyun;

import com.alibaba.fastjson.JSON;
import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static Log logger = LogFactory.getLog(HttpClientUtils.class);
    private static final String CONTENT_TYPE_APPLICATION_JSON = MediaType.JSON_UTF_8.toString();
    private static PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpClient = null;
    private static final int DEFAULT_MAX_TOTAL_CONNECTION = 1024;
    private static final int DEFAULT_MAX_PER_ROUTE = 300;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String CONTENT_TYPE_TEXT_XML = "application/xml";
    private static final String APPLICATION_XML = "text/xml";
    private static final int DEFAULT_CONNECTION_TIME_OUT = 60000;
    private static final int DEFAULT_READ_TIME_OUT = 60000;

    private HttpClientUtils() {
    }

    public static String invokeGet(String url, Map<String, String> params) {
        return HttpClientUtils.invokeGet(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String szylPost(String url, Map<String, String> params) {
        return HttpClientUtils.szylPost(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String ysPost(String url, String params) {
        return HttpClientUtils.ysPost(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String mpPost(String url, String params) {
        return HttpClientUtils.mpPost(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String jaPost(String url, String params) {
        return HttpClientUtils.jaPost(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String csssPost(String url, List<NameValuePair> parameters) {
        return HttpClientUtils.csssPost(url, parameters, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String jaFacePost(String url, HttpEntity entity) {
        return HttpClientUtils.jaFacePost(url, entity, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String tyPost(String url, String params) {
        return HttpClientUtils.tyPost(url, params, CONTENT_TYPE_APPLICATION_JSON, 60000, 60000);
    }

    public static String yjPost(String url, String params) {
        return HttpClientUtils.yjPost(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String szylPost(String url, Map<String, String> params, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                BasicNameValuePair nameValue = new BasicNameValuePair(entry.getKey(), entry.getValue());
                formParams.add(nameValue);
            }
        }
        HttpPost httpGet = new HttpPost(url);
        UrlEncodedFormEntity ueEntity = new UrlEncodedFormEntity(formParams, Charset.forName(DEFAULT_ENCODING));
        httpGet.setHeader("Connection", "close");
        httpGet.setConfig(requestConfig);
        httpGet.setEntity((HttpEntity)ueEntity);
        String responseString = HttpClientUtils.doSzylRequest((HttpRequestBase)httpGet, encode);
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ysPost(String url, String jsonReq, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpGet = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpGet = new HttpPost(url);
            httpGet.setHeader("Connection", "close");
            httpGet.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonReq, "utf-8");
            entity.setContentEncoding(DEFAULT_ENCODING);
            entity.setContentType("application/json");
            httpGet.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpGet);
            try {
                HttpEntity respEntity = response.getEntity();
                try {
                    if (respEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)respEntity, (String)encode);
                    }
                }
                finally {
                    if (respEntity != null) {
                        respEntity.getContent().close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)String.format("[HttpClientUtils.doRequest] get response error, url:%s", httpGet.getURI()), (Throwable)e);
                responseString = "";
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpGet.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mpPost(String url, String jsonReq, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpPost = new HttpPost(url);
            httpPost.setHeader("Connection", "Keep-Alive");
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            httpPost.setHeader("Charset", DEFAULT_ENCODING);
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonReq, "utf-8");
            entity.setContentEncoding(DEFAULT_ENCODING);
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            try {
                HttpEntity respEntity = response.getEntity();
                try {
                    if (respEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)respEntity, (String)encode);
                    }
                }
                finally {
                    if (respEntity != null) {
                        respEntity.getContent().close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)String.format("[HttpClientUtils.doRequest] get response error, url:%s", httpPost.getURI()), (Throwable)e);
                responseString = "";
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpPost.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String csssPost(String url, List<NameValuePair> parameters, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            URL url1 = new URL(url);
            URI uri = new URI(url1.getProtocol(), url1.getUserInfo(), url1.getHost(), url1.getPort(), url1.getPath(), url1.getQuery(), null);
            httpPost = new HttpPost(uri);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpPost.setConfig(requestConfig);
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters, encode);
            httpPost.setEntity((HttpEntity)formEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            try {
                HttpEntity respEntity = response.getEntity();
                try {
                    if (respEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)respEntity, (String)encode);
                    }
                }
                finally {
                    if (respEntity != null) {
                        respEntity.getContent().close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)String.format("[HttpClientUtils.doRequest] get response error, url:%s", httpPost.getURI()), (Throwable)e);
                responseString = "";
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpPost.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpPost.releaseConnection();
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jaPost(String url, String jsonReq, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpGet = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpGet = new HttpPost(url);
            httpGet.setHeader("xa-key", "zOyducNb7gYwkcaOUaCXPUDhRZYQ0q6R1+NniijwsdU=");
            httpGet.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonReq, "utf-8");
            entity.setContentEncoding(DEFAULT_ENCODING);
            entity.setContentType("application/json");
            httpGet.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpGet);
            try {
                HttpEntity respEntity = response.getEntity();
                try {
                    if (respEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)respEntity, (String)encode);
                    }
                }
                finally {
                    if (respEntity != null) {
                        respEntity.getContent().close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)String.format("[HttpClientUtils.doRequest] get response error, url:%s", httpGet.getURI()), (Throwable)e);
                responseString = "";
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpGet.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jaFacePost(String url, HttpEntity entity, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpGet = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpGet = new HttpPost(url);
            httpGet.setHeader("xa-key", "zOyducNb7gYwkcaOUaCXPUDhRZYQ0q6R1+NniijwsdU=");
            httpGet.setConfig(requestConfig);
            httpGet.setEntity(entity);
            response = httpClient.execute((HttpUriRequest)httpGet);
            try {
                HttpEntity respEntity = response.getEntity();
                try {
                    if (respEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)respEntity, (String)encode);
                    }
                }
                finally {
                    if (respEntity != null) {
                        respEntity.getContent().close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)String.format("[HttpClientUtils.doRequest] get response error, url:%s", httpGet.getURI()), (Throwable)e);
                responseString = "";
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpGet.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return responseString;
    }

    public static String yjPost(String url, String jsonReq, String encode, int connectTimeout, int readTimeout) {
        try {
            String line;
            URL obj = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            PrintWriter out = new PrintWriter(conn.getOutputStream());
            out.print(jsonReq);
            out.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), encode));
            StringBuffer response = new StringBuffer();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            br.close();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doSzylRequest(HttpRequestBase httpRequestBase, String encode) {
        String responseString = null;
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)("HttpClientUtils Begin Invoke: " + httpRequestBase.getURI() + ", cost time " + (System.currentTimeMillis() - start) + " ms"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequestBase);){
                HttpEntity entity = response.getEntity();
                try {
                    if (entity != null) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)encode);
                    }
                }
                finally {
                    if (entity != null) {
                        entity.getContent().close();
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (Exception e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        finally {
            httpRequestBase.releaseConnection();
        }
        return responseString;
    }

    public static String invokeGet(String url, Map<String, String> params, String encode, int connectTimeout, int readTimeout) {
        String requestUrl;
        if (connectTimeout <= 0) {
            return null;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        try {
            requestUrl = HttpClientUtils.buildRequestUrl(url, params);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("encode http get params error, params is " + params), (Throwable)e);
            return "";
        }
        HttpPost httpGet = new HttpPost(requestUrl);
        httpGet.setHeader("Connection", "close");
        httpGet.setConfig(requestConfig);
        String responseString = HttpClientUtils.doRequest((HttpRequestBase)httpGet, encode);
        return responseString;
    }

    public static String invokePost(String requestUrl, Map<String, Object> params) {
        return HttpClientUtils.invokePost(requestUrl, params, null, null, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String lrPost(String url, Map<String, Object> params) {
        return HttpClientUtils.lrPost(url, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String invokePost(String requestUrl, Map<String, String> requestHeader, String requestBody) {
        return HttpClientUtils.invokePost(requestUrl, null, requestHeader, requestBody, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String yuanShuPost(String url, String body, Map<String, String> params) {
        return HttpClientUtils.yuanShuPost(url, body, params, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String invokePost(String requestUrl, Map<String, Object> params, Map<String, String> requestHeader, String requestBody, String encode, int connectTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        HttpPost httpPost = new HttpPost(requestUrl);
        httpPost.setConfig(requestConfig);
        if (MapUtils.isNotEmpty(requestHeader)) {
            for (Map.Entry<String, String> entry : requestHeader.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        HttpClientUtils.buildPostParams(httpPost, params, requestBody, encode);
        String responseString = HttpClientUtils.doRequest((HttpRequestBase)httpPost, encode);
        return responseString;
    }

    private static void buildPostParams(HttpPost httpPost, Map<String, Object> params, String requestBody, String encode) {
        try {
            if (MapUtils.isNotEmpty(params)) {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String value = null;
                    value = entry.getValue() instanceof String ? (String)entry.getValue() : JSON.toJSONString((Object)entry.getValue());
                    nameValuePairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, encode));
            }
            if (StringUtils.isNotBlank((String)requestBody)) {
                httpPost.setEntity((HttpEntity)new StringEntity(requestBody, encode));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("HttpClientUtils.buildPostParams error, params = " + params), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doRequest(HttpRequestBase httpRequestBase, String encode) {
        String responseString = null;
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)("HttpClientUtils Begin Invoke: " + httpRequestBase.getURI() + ", cost time " + (System.currentTimeMillis() - start) + " ms"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpRequestBase);){
                HttpEntity entity = response.getEntity();
                try {
                    if (entity != null) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)encode);
                    }
                }
                finally {
                    if (entity != null) {
                        entity.getContent().close();
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (Exception e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        finally {
            httpRequestBase.releaseConnection();
        }
        logger.info((Object)("HttpClientUtils response : " + responseString));
        return responseString;
    }

    private static String buildRequestUrl(String url, Map<String, String> params) throws UnsupportedEncodingException {
        if (CollectionUtils.isEmpty(params)) {
            return url;
        }
        StringBuilder requestUrl = new StringBuilder();
        requestUrl.append(url);
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (i == 0) {
                requestUrl.append("?");
            }
            requestUrl.append(entry.getKey());
            requestUrl.append("=");
            String value = entry.getValue();
            requestUrl.append(URLEncoder.encode(value, DEFAULT_ENCODING));
            requestUrl.append("&");
            ++i;
        }
        requestUrl.deleteCharAt(requestUrl.length() - 1);
        return requestUrl.toString();
    }

    public static boolean canWxPay(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null || userAgent.indexOf("MicroMessenger/") == -1) {
            return false;
        }
        String version = StringUtils.substringAfter((String)userAgent, (String)"MicroMessenger/").substring(0, 3);
        Float srcVersion = Float.valueOf(Float.parseFloat(version));
        Float targetVersion = Float.valueOf(5.0f);
        return srcVersion.floatValue() > targetVersion.floatValue();
    }

    public static void setStringParams(HttpPost httpost, Map<String, String> params) {
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key).toString()));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            log.info(e.getMessage(), (Throwable)e);
        }
    }

    public static String jiXinPost(String reqUrl, byte[] str) {
        return HttpClientUtils.jiXinPost(reqUrl, str, DEFAULT_ENCODING, 60000, 60000);
    }

    public static String jiXinPost(String url, byte[] reponse, String encode, int connectTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        String resp = new String(reponse, Charset.forName(DEFAULT_ENCODING));
        HttpPost httpGet = new HttpPost(url);
        StringEntity entity = new StringEntity(resp, "utf-8");
        httpGet.setConfig(requestConfig);
        httpGet.setEntity((HttpEntity)entity);
        String responseString = HttpClientUtils.doSzylRequest((HttpRequestBase)httpGet, encode);
        return responseString;
    }

    public static String lrPost(String url, Map<String, Object> params, String encode, int connectTimeout, int readTimeout) {
        PoolingHttpClientConnectionManager connManager = null;
        try {
            SSLContext sslcontext = HttpClientUtils.createIgnoreVerifySSL();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslFactory).build();
            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(1024);
            connManager.setDefaultMaxPerRoute(300);
            HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair nameValue = new BasicNameValuePair(entry.getKey(), (String)entry.getValue());
                formParams.add(nameValue);
            }
        }
        HttpPost httpGet = new HttpPost(url);
        UrlEncodedFormEntity ueEntity = new UrlEncodedFormEntity(formParams, Charset.forName(DEFAULT_ENCODING));
        httpGet.setConfig(requestConfig);
        httpGet.setEntity((HttpEntity)ueEntity);
        String responseString = HttpClientUtils.doLrRequest((HttpRequestBase)httpGet, encode, connManager);
        return responseString;
    }

    private static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSLv3");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, null);
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doLrRequest(HttpRequestBase httpRequestBase, String encode, PoolingHttpClientConnectionManager connManager) {
        String responseString = null;
        try {
            long start = System.currentTimeMillis();
            CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            logger.info((Object)("HttpClientUtils Begin Invoke: " + httpRequestBase.getURI() + ", cost time " + (System.currentTimeMillis() - start) + " ms"));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpRequestBase);){
                HttpEntity entity = response.getEntity();
                try {
                    if (entity != null) {
                        responseString = EntityUtils.toString((HttpEntity)entity, (String)encode);
                    }
                }
                finally {
                    if (entity != null) {
                        entity.getContent().close();
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (Exception e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get error, url:%s", httpRequestBase.getURI()), (Throwable)e);
            responseString = "";
        }
        finally {
            httpRequestBase.releaseConnection();
        }
        logger.info((Object)("HttpClientUtils response : " + responseString));
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String yuanShuPost(String url, String body, Map<String, String> headers, String encode, int connectTimeout, int readTimeout) {
        HttpURLConnection connection = null;
        InputStream is = null;
        OutputStream os = null;
        BufferedReader br = null;
        String result = null;
        try {
            URL httpUrl = new URL(url);
            connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            os = connection.getOutputStream();
            os.write(body.getBytes(DEFAULT_ENCODING));
            if (connection.getResponseCode() == 200) {
                is = connection.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, DEFAULT_ENCODING));
                StringBuffer sbf = new StringBuffer();
                String temp = null;
                while ((temp = br.readLine()) != null) {
                    sbf.append(temp);
                    sbf.append("\r\n");
                }
                result = sbf.toString();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            connection.disconnect();
        }
        return result;
    }

    private static String sendRequest(HttpRequestBase httpRequest, HttpEntity entity) {
        httpRequest.setHeader("User-Agent", "okHttp");
        if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
        }
        SSLContext sslContext = SSLContexts.createDefault();
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sslContext.init(null, new TrustManager[]{tm}, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
        Registry r = RegistryBuilder.create().register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(r);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        CloseableHttpResponse response = null;
        String resString = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest);
            HttpEntity resEntity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            resString = EntityUtils.toString((HttpEntity)resEntity, (String)DEFAULT_ENCODING);
            System.err.println(statusCode);
            if (statusCode != 200) {
                System.out.println("\u54cd\u5e94\u7801\u72b6\u6001\u4e0d\u662f200");
            }
            String string = resString;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(resString, e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpRequest != null) {
                    httpRequest.releaseConnection();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tyPost(String url, String jsonReq, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpGet = null;
        Object response = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpGet = new HttpPost(url);
            httpGet.setHeader("Connection", "close");
            httpGet.setConfig(requestConfig);
            StringEntity entity = new StringEntity(jsonReq, "utf-8");
            entity.setContentEncoding(DEFAULT_ENCODING);
            entity.setContentType("application/json");
            httpGet.setEntity((HttpEntity)entity);
            responseString = HttpClientUtils.sendRequest((HttpRequestBase)httpGet, (HttpEntity)entity);
            if (response != null) {
                response.close();
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpGet.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return responseString;
    }

    public static String hyPost(String url, Map<String, Object> map, String charset) {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpClients.createDefault();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> elem : map.entrySet()) {
                list.add(new BasicNameValuePair(elem.getKey(), String.valueOf(elem.getValue())));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                httpPost.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            System.out.println(response.getEntity());
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String ysfrPost(String url, String xmlReq) {
        return HttpClientUtils.doYsfrPost(url, xmlReq, DEFAULT_ENCODING, 60000, 60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doYsfrPost(String url, String xmlReq, String encode, int connectTimeout, int readTimeout) {
        if (connectTimeout <= 0) {
            return null;
        }
        String responseString = null;
        HttpPost httpGet = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(readTimeout).setConnectionRequestTimeout(connectTimeout).setSocketTimeout(connectTimeout).build();
            httpGet = new HttpPost(url);
            httpGet.setHeader("Connection", "close");
            httpGet.setConfig(requestConfig);
            StringEntity entity = new StringEntity(xmlReq, "utf-8");
            entity.setContentEncoding(APPLICATION_XML);
            entity.setContentType(CONTENT_TYPE_TEXT_XML);
            httpGet.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpGet);
            try {
                HttpEntity respEntity = response.getEntity();
                try {
                    if (respEntity != null) {
                        responseString = EntityUtils.toString((HttpEntity)respEntity, (String)encode);
                    }
                }
                finally {
                    if (respEntity != null) {
                        respEntity.getContent().close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)String.format("[HttpClientUtils.doRequest] get response error, url:%s", httpGet.getURI()), (Throwable)e);
                responseString = "";
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)String.format("[HttpClientUtils.doRequest] invoke get timout error, url:%s", httpGet.getURI()), (Throwable)e);
            responseString = "";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return responseString;
    }

    static {
        log.info("\u521d\u59cb\u5316\u958b\u59cb:");
        poolingHttpClientConnectionManager.setMaxTotal(1024);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(300);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
        log.info("\u521d\u59cb\u5316\u7d50\u675f:");
    }
}

