/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.jizhengyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.jizhengyun.RsaSignature;
import com.bxm.shopping.integration.jizhengyun.ThreeDesUtil;
import com.bxm.shopping.integration.jizhengyun.model.ClientRequest;
import com.bxm.shopping.integration.jizhengyun.model.SerialNumberUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class IdCardVerifyIntegration {
    private static final Logger log = LoggerFactory.getLogger(IdCardVerifyIntegration.class);
    private static final Integer RESULT_SUCCESS = 1;
    private static final String CODE_SUCCESS = "0000";
    private static final List<String> EXCLUDE_CODE = Collections.singletonList("1008");
    private static String baseUrl = "http://api.jizhengyun.com/v1.0/realname/";
    @Autowired
    private RestTemplate restTemplate;

    public boolean verify(String name, String idCard) {
        try {
            String resp = this.invoke(name, idCard.toUpperCase());
            Boolean result = this.analyzeResponse(resp);
            log.info("\u59d3\u540d{},\u8eab\u4efd\u8bc1\u53f7\uff1a{}, verify result: {}", new Object[]{name, idCard, result});
            return result;
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private Boolean analyzeResponse(String resp) {
        Integer result;
        String dataStr;
        JSONObject dataJSON;
        JSONObject RespJSON = (JSONObject)JSONObject.parseObject((String)resp, JSONObject.class);
        log.info(RespJSON.toJSONString());
        String MessageStr = RespJSON.getString("message");
        JSONObject messageJSON = (JSONObject)JSONObject.parseObject((String)MessageStr, JSONObject.class);
        String CODE = RespJSON.getString("code");
        if (!CODE.equals(CODE_SUCCESS) && EXCLUDE_CODE.contains(CODE)) {
            return false;
        }
        if (null != messageJSON && (dataJSON = (JSONObject)JSONObject.parseObject((String)(dataStr = messageJSON.getString("data")), JSONObject.class)) != null && RESULT_SUCCESS.equals(result = (Integer)dataJSON.get((Object)"result"))) {
            return true;
        }
        return false;
    }

    public String invoke(String name, String cert_no) throws UnsupportedEncodingException {
        String out_trade_no = SerialNumberUtil.createBillNo();
        String tran_time = "2021-08-23 16:21:30";
        String verify_type = "0220";
        String cutomer_code = "1016116848928614";
        String url = baseUrl + cutomer_code;
        String des_key = "0bWvXXvu4Aj4TDXAY3Qr95VU";
        String rsa_key = "MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBAMrvjQrflC/GrmmlI9/9Gr4CjdH4uUZWyWo4kIQi+C/rapxMpSBMew3IdJp8bJO7rFH1boFr8xI6zv0tRt0nVe5a51EHLpz0sUZRIs32DSu7JpTf9qbsD2lYyTeFDUJCZ9QvhcdiSTc39QHAak/KlLGriR1KtmZj94c0ZjAEaGiNAgMBAAECgYBfl53RrGWqZ6WKwC54+UnajWtuqAHmP0VbUs/IXoyYTgWHIJd78mrYoD9E8i1XHcVbSghG0KnMQYV1PxmtXTUdXah/Vi6sW7nfGQIUOP2cALLGFDB2cKu4VF4CtLp3YObNb5/RBmBSaVIb8Ed3Ko3JPPzK2J7FosXh7p8J/ii8xQJBAPcLmW40zd7g8L7t84sSAgrji+nPoTCoUfX+F4+Vj73ZaM/vt5lzm/wK/joT6YLIZ70FOoTTmWS+uZi4hZRPeU8CQQDSSqWfNjUhWuvTQp3wiMzPJS7/92J3flXepgPVJmVk0bPa76QUOCP3Bf2iQVdLregSq6iMI77+nLspSFePbdFjAkAUOjjn0x8AHr7XgzgrrN/J8HOmQz/Zcg6z64gWU5KfYsu4KtKHl/Wvn17Ndo/qC2qjCWiPM5wdqZgcrw8Q46j1AkAmgUSSQnq4AM3tgOUqheH6i/RvKfz9pERU4FETVlR6gWtNS1Pf3+e184LdktlJIi68PHJANstiE5Cxnm1p9dHBAkBaGXXPRuOCjhzSpsrLmZ9D9y5/GJSBioI1DBLpDmBZC+Dzo+bIJBrwHiAeM84dVq194wo4MwwYoOo9VxXtn3ik";
        ClientRequest molinkRequest = new ClientRequest();
        molinkRequest.setOut_trade_no(out_trade_no);
        molinkRequest.setTran_time(tran_time);
        molinkRequest.setVerify_type(verify_type);
        molinkRequest.setCustomer_code(cutomer_code);
        molinkRequest.setName(new String(name.getBytes(), "UTF-8"));
        molinkRequest.setCert_no(cert_no);
        StringBuilder builder = new StringBuilder();
        builder.append("out_trade_no".toUpperCase() + "=" + out_trade_no);
        builder.append("&" + "tran_time".toUpperCase() + "=" + tran_time);
        builder.append("&" + "verify_type".toUpperCase() + "=" + verify_type);
        builder.append("&" + "name".toUpperCase() + "=" + name);
        builder.append("&" + "cert_no".toUpperCase() + "=" + cert_no);
        String sign = RsaSignature.rsaSign(builder.toString(), rsa_key, "UTF-8");
        molinkRequest.setSign(sign);
        String json = JSON.toJSONString((Object)molinkRequest);
        byte[] keybyte = des_key.getBytes();
        byte[] requsest = ThreeDesUtil.encryptMode(keybyte, json.getBytes());
        String code = (String)this.restTemplate.postForObject(url, (Object)ThreeDesUtil.byte2Hex(requsest), String.class, new Object[0]);
        log.info("\u8eab\u4efd\u9a8c\u8bc1\u63a5\u53e3\u8fd4\u56de\u6570\u636e: {}", (Object)code);
        return code;
    }
}

