/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.kuaidi;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.integration.kuaidi.config.CallbackConfig;
import com.bxm.shopping.integration.kuaidi.model.HttpResult;
import com.bxm.shopping.integration.kuaidi.model.QueryTrackParam;
import com.bxm.shopping.integration.kuaidi.model.QueryTrackReq;
import com.bxm.shopping.integration.kuaidi.model.QueryTrackResp;
import com.bxm.shopping.integration.kuaidi.model.SubscribeParam;
import com.bxm.shopping.integration.kuaidi.model.SubscribeParameters;
import com.bxm.shopping.integration.kuaidi.model.SubscribeReq;
import com.bxm.shopping.integration.kuaidi.model.SubscribeResp;
import com.bxm.shopping.integration.kuaidi.utils.HttpUtils;
import com.bxm.shopping.integration.kuaidi.utils.SignUtils;
import com.bxm.warcar.utils.JsonHelper;
import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Configuration
public class KuaidiIntegration {
    private static final Logger log = LoggerFactory.getLogger(KuaidiIntegration.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CallbackConfig callbackConfig;
    private static final String KEY = "Eoewtnku9597";
    private static final String CUSTOMER = "39D4EB0FA0CA33A4E699D3AEA10CDF99";
    public static final String SALT = "bxm";

    public SubscribeResp subscribeOrder(String number, String company, String orderNum) {
        String callbackUrl = this.callbackConfig.getUrl();
        SubscribeResp subscribe = new SubscribeResp();
        if (StringUtils.isBlank((CharSequence)callbackUrl)) {
            log.error("\u672a\u914d\u7f6e\u5feb\u9012100\u8ba2\u9605\u56de\u8c03\u63a5\u53e3\uff01");
            return subscribe;
        }
        SubscribeReq subscribeReq = new SubscribeReq();
        subscribeReq.setSchema("json");
        SubscribeParam subscribeParam = new SubscribeParam();
        SubscribeParameters subscribeParameters = new SubscribeParameters();
        subscribeParameters.setCallbackurl(callbackUrl + "?orderNum=" + orderNum + "&trackingNum=" + number);
        subscribeParameters.setSalt(SALT);
        subscribeParam.setParameters(subscribeParameters);
        subscribeParam.setCompany(company);
        subscribeParam.setNumber(number);
        subscribeParam.setKey(KEY);
        subscribeReq.setParam(subscribeParam);
        try {
            subscribe = this.subscribe(subscribeReq);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528kuaidi100\u8ba2\u9605\u63a5\u53e3\u51fa\u9519", (Throwable)e);
        }
        return subscribe;
    }

    public QueryTrackResp queryTrack(String trackingNum, String company) {
        QueryTrackReq queryTrackReq = new QueryTrackReq();
        QueryTrackParam queryTrackParam = new QueryTrackParam();
        queryTrackParam.setCom(company);
        queryTrackParam.setNum(trackingNum);
        queryTrackReq.setParam(queryTrackParam);
        queryTrackReq.setCustomer(CUSTOMER);
        queryTrackReq.setSign(SignUtils.sign(new Gson().toJson((Object)queryTrackParam) + KEY + CUSTOMER));
        QueryTrackResp queryTrackResp = new QueryTrackResp();
        HttpResult httpResult = HttpUtils.doPost("https://poll.kuaidi100.com/poll/query.do", queryTrackReq);
        if (httpResult.getStatus() == HttpStatus.OK.value() && StringUtils.isNotBlank((CharSequence)httpResult.getBody())) {
            queryTrackResp = (QueryTrackResp)new Gson().fromJson(httpResult.getBody(), QueryTrackResp.class);
        }
        return queryTrackResp;
    }

    public SubscribeResp subscribe(SubscribeReq subscribeReq) throws IllegalAccessException {
        MultiValueMap<String, String> params = HttpUtils.objectToMultiValueMap(subscribeReq);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/x-www-form-urlencoded; charset=UTF-8"));
        JSONObject postParameters = new JSONObject();
        postParameters.put("param", (Object)subscribeReq);
        HttpEntity subscribeRespHttpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity("https://poll.kuaidi100.com/poll", (Object)subscribeRespHttpEntity, String.class, new Object[0]);
        SubscribeResp subscribeResp = new SubscribeResp();
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && StringUtils.isNotBlank((CharSequence)((CharSequence)responseEntity.getBody()))) {
            subscribeResp = (SubscribeResp)JsonHelper.convert((String)((String)responseEntity.getBody()), SubscribeResp.class);
        }
        return subscribeResp;
    }
}

