/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.kuaidi.utils;

import com.bxm.shopping.integration.kuaidi.model.HttpResult;
import com.bxm.warcar.utils.JsonHelper;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class HttpUtils {
    private static final String CHARSET_DEFAULT = "UTF-8";
    private static Logger record = LoggerFactory.getLogger((String)"record");
    private static Boolean isRecord = true;
    private static PoolingHttpClientConnectionManager pool;
    private static RequestConfig reqConfig;
    private static CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult doPost(String url, Object obj) {
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            Map<String, String> params = HttpUtils.objectToMap(obj);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(reqConfig);
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, CHARSET_DEFAULT));
            }
            resp = httpClient.execute((HttpUriRequest)httpPost);
            String body = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)CHARSET_DEFAULT);
            int statusCode = resp.getStatusLine().getStatusCode();
            if (isRecord.booleanValue()) {
                record.info("{}|{}|{}|{}", new Object[]{url, new Gson().toJson(obj), statusCode, body});
            }
            result.setStatus(statusCode);
            result.setBody(body);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != resp) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static Map<String, String> objectToMap(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            String fieldValue = "";
            fieldValue = field.getType() == String.class || field.getType() == Integer.class || field.getType() == Integer.TYPE ? (field.get(obj) == null ? "" : field.get(obj).toString()) : new Gson().toJson(field.get(obj));
            map.put(fieldName, fieldValue);
        }
        return map;
    }

    public static MultiValueMap<String, String> objectToMultiValueMap(Object obj) throws IllegalAccessException {
        if (obj == null) {
            return null;
        }
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            String fieldValue = "";
            fieldValue = field.getType() == String.class || field.getType() == Integer.class || field.getType() == Integer.TYPE ? (field.get(obj) == null ? "" : field.get(obj).toString()) : JsonHelper.convert((Object)field.get(obj));
            map.add((Object)fieldName, (Object)fieldValue);
        }
        return map;
    }

    static {
        try {
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
            pool = new PoolingHttpClientConnectionManager(registry);
            pool.setMaxTotal(20);
            pool.setDefaultMaxPerRoute(5);
            reqConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).setExpectContinueEnabled(false).build();
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pool).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

