/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.liantong;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.integration.liantong.model.ReqHeadBean;
import com.bxm.shopping.integration.liantong.model.ReqObj;
import com.bxm.shopping.integration.liantong.model.SecurityTool;
import com.bxm.shopping.integration.liantong.model.SendCaptchaBody;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class LianTongCaptchaIntegration {
    private static final Logger log = LoggerFactory.getLogger(LianTongCaptchaIntegration.class);
    public static final String LINK1 = "/link/king/card/message/send/v2";
    public static final String LINK2 = "/link/king/card/message/check/v2";
    private static final String CHANNEL = "08-2278-a3zb-a4n0";
    private static final String SUCCESS_CODE = "0000";
    private static final String CODE_IDCARD_VERIFY = "C001";
    private static final String APP_CODE = "CDA1B8024E794A16A165B3CD0DB0921F";
    private static final String URL = "http://123.125.96.156/zop/";
    private static final String AES = "uRkCSN8eAi1jEFvUmfWF1Q==";
    private static final String HMAC = "YFkl81Kl7ZS8C9szVrl8jCU4yN7yPZZ0bF9qrz6F3B5IMQmbxvozFFMfkwyM5veu2xZPDnuaz1/FGnWxQE0RHA==";
    @Autowired
    private RestTemplate restTemplate;

    public static void main(String[] args) throws Exception {
        LianTongCaptchaIntegration integration = new LianTongCaptchaIntegration();
        integration.send("43062119961003041X", "13296731087");
    }

    public void send(String idCard, String mobile) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)idCard), (Object)"\u8bf7\u586b\u5199\u8eab\u4efd\u8bc1");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"\u8bf7\u586b\u5199\u624b\u673a\u53f7");
        try {
            log.info("\u8bf7\u6c42\u8054\u901a\u53d1\u9001\u9a8c\u8bc1\u7801\u63a5\u53e3 mobile:{} idCard:{}", (Object)mobile, (Object)idCard);
            this.doRequest(idCard, mobile, null);
        }
        catch (ShoppingException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ShoppingException("\u8bf7\u6c42\u9a8c\u8bc1\u7801\u5f02\u5e38");
        }
    }

    public boolean verifyCaptcha(String idCard, String mobile, String captcha) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)idCard), (Object)"\u8bf7\u586b\u5199\u8eab\u4efd\u8bc1");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)mobile), (Object)"\u8bf7\u586b\u5199\u624b\u673a\u53f7");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)captcha), (Object)"\u8bf7\u586b\u5199\u9a8c\u8bc1\u7801");
        try {
            log.info("\u8bf7\u6c42\u8054\u901a\u68c0\u6d4b\u9a8c\u8bc1\u7801\u63a5\u53e3 mobile:{} idCard:{} captcha:{}", new Object[]{mobile, idCard, captcha});
            this.doRequest(idCard, mobile, captcha);
        }
        catch (ShoppingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ShoppingException("\u9a8c\u8bc1\u5f02\u5e38");
        }
        return true;
    }

    private void doRequest(String idCard, String mobile, String captcha) throws Exception {
        String uuid = String.valueOf(UUID.randomUUID());
        JSONObject baseReq = new JSONObject();
        baseReq.put("appCode", (Object)APP_CODE);
        ReqObj obj = new ReqObj();
        ReqHeadBean head = new ReqHeadBean();
        head.setTimestamp(new DateTime().toString("yyyy-MM-dd HH:mm:ss.SSS"));
        head.setUuid(uuid);
        head.setSign(this.makeSign(head, APP_CODE));
        obj.setHead(head);
        SendCaptchaBody body = new SendCaptchaBody();
        body.setCertId(idCard);
        body.setChannel(CHANNEL);
        body.setContactNum(mobile);
        body.setCaptcha(captcha);
        obj.setBody(body);
        baseReq.put("reqObj", (Object)SecurityTool.encrypt(AES, JSONObject.toJSONString((Object)obj)));
        String myUrl = StringUtils.isNotBlank((CharSequence)captcha) ? "http://123.125.96.156/zop//link/king/card/message/check/v2?uuid=" + uuid : "http://123.125.96.156/zop//link/king/card/message/send/v2?uuid=" + uuid;
        log.info("\u8bf7\u6c42\u8054\u901a\u62a5\u6587\uff1a" + JSONObject.toJSONString((Object)baseReq));
        String response = (String)this.restTemplate.postForObject(myUrl, (Object)JSONObject.toJSONString((Object)baseReq), String.class, new Object[0]);
        log.info("\u8054\u901a\u63a5\u53e3\u54cd\u5e94\uff1a{}, idCard:{}, mobile:{}, captcha:{}", new Object[]{response, idCard, mobile, captcha});
        JSONObject responseJSON = (JSONObject)JSONObject.parseObject((String)response, JSONObject.class);
        String rspCode = responseJSON.getString("rspCode");
        String rspDesc = responseJSON.getString("rspDesc");
        if (!SUCCESS_CODE.equals(rspCode)) {
            if (CODE_IDCARD_VERIFY.equals(rspCode)) {
                throw new ShoppingException("\u8eab\u4efd\u8bc1\u53f7\u6216\u624b\u673a\u53f7\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002");
            }
            throw new ShoppingException(rspDesc);
        }
    }

    private String makeSign(ReqHeadBean req, String appCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("appCode").append(appCode).append("timestamp").append(req.getTimestamp()).append("uuid").append(req.getUuid()).append(HMAC);
        return SecurityTool.sign(HMAC, sb.toString());
    }
}

