/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.pay;

import com.bxm.pay.facade.PayService;
import com.bxm.pay.facade.model.Order;
import com.bxm.pay.facade.model.RefundResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PayFacadeIntegration {
    private static final Logger log = LoggerFactory.getLogger(PayFacadeIntegration.class);
    @Autowired
    private PayService payService;

    public String pay(Order order) {
        return this.payService.pay(order);
    }

    public Boolean refund(Order order) {
        RefundResult refund = this.payService.refund(order);
        log.info("orderNo:{} pay service refund resultMsg:{}", (Object)order.getOrderNum(), (Object)refund.getMsg());
        if ("10000".equals(refund.getCode())) {
            return true;
        }
        return false;
    }
}

