/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.wechat;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.exception.WeixinException;
import com.bxm.shopping.integration.wechat.WeixinSupport;
import com.bxm.shopping.integration.wechat.config.WechatConfig;
import com.bxm.shopping.integration.wechat.model.SnsAccessToken;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class WechatAuthIntegration
extends WeixinSupport {
    private static final Logger log = LoggerFactory.getLogger(WechatAuthIntegration.class);
    @Autowired
    private WechatConfig wechatConfig;
    @Autowired
    private RestTemplate restTemplate;

    public String getOpenId(String code) throws WeixinException {
        SnsAccessToken snsOAuth2AccessToken = this.getSnsOAuth2AccessToken(code);
        return snsOAuth2AccessToken.getOpenid();
    }

    public SnsAccessToken getSnsOAuth2AccessToken(String code) throws WeixinException {
        if (StringUtils.isEmpty((String)code)) {
            throw new IllegalArgumentException("code can't be null or empty");
        }
        String param = "?appid=" + this.wechatConfig.getAppId() + "&secret=" + this.wechatConfig.getSecret() + "&code=" + code + "&grant_type=authorization_code";
        String jsonStr = (String)this.restTemplate.getForObject(this.wechatConfig.getAccessTokenUrl() + param, String.class, new Object[0]);
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        if (jsonObj == null) {
            return null;
        }
        Object errcode = jsonObj.get((Object)"errcode");
        if (errcode != null) {
            throw new WeixinException(this.getCause(jsonObj.getIntValue("errcode")));
        }
        return new SnsAccessToken(jsonObj);
    }
}

