/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.integration.wechat.model;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.exception.WeixinException;

public final class SnsAccessToken {
    private String access_token;
    private int expires_in = 7200;
    private String refresh_token;
    private long expired_time;
    private String openid;
    private String scope;

    public SnsAccessToken(JSONObject jsonObj) throws WeixinException {
        this.access_token = jsonObj.getString("access_token");
        this.expires_in = jsonObj.getIntValue("expires_in");
        this.refresh_token = jsonObj.getString("refresh_token");
        this.openid = jsonObj.getString("openid");
        this.scope = jsonObj.getString("scope");
        this.expired_time = System.currentTimeMillis() + (long)(this.expires_in * 1000);
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public boolean isExprexpired() {
        return System.currentTimeMillis() > this.expired_time;
    }

    public String toString() {
        return "{\"scope\":\"" + this.getScope() + "\",\"openid\":\"" + this.getOpenid() + "\",\"expires_in\":" + this.getExpires_in() + ",\"refresh_token\":\"" + this.getRefresh_token() + "\",\"access_token\":\"" + this.getAccess_token() + "\"}";
    }

    public int getExpires_in() {
        return this.expires_in;
    }

    public void setExpires_in(int expires_in) {
        this.expires_in = expires_in;
    }

    public String getRefresh_token() {
        return this.refresh_token;
    }

    public void setRefresh_token(String refresh_token) {
        this.refresh_token = refresh_token;
    }

    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

