package com.bxm.shopping.model.dto;

import com.bxm.shopping.model.ValidateGroups;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author tangx
 * @date 2021/8/25 15:37
 */
@Data
public class AddressLibraryDto {

    @NotNull(groups = {ValidateGroups.Update.class}, message = "id不能为空")
    private Integer id;

    /**
     * 地址库名称
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "name不能为空")
    private String name;

    /**
     * 文件地址
     */
    private String url;

    /**
     * 地址内容
     */
    @NotBlank(groups = {ValidateGroups.Add.class}, message = "data不能为空")
    private String data;

    @NotNull(groups = {ValidateGroups.Add.class}, message = "totalNum不能为空")
    private Integer totalNum;
}
