package com.bxm.shopping.model.dto;

import com.bxm.shopping.model.ValidateGroups;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 协议表
 * </p>
 *
 * @author tangxiao
 * @since 2022-04-19
 */
@Data
public class AgreementDto {


      @NotNull(groups = {ValidateGroups.Update.class}, message = "id不能为空")
      private Integer id;

      /**
     * 广告主id
     */
      @NotNull(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "广告主id不能为空")
      private Integer advertiserId;

      /**
     * 协议名称
     */
      @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "协议名称不能为空")
      private String name;

      /**
     * 协议内容
     */
      @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "协议内容不能为空")
      private String content;
}
