package com.bxm.shopping.model.dto;

import com.bxm.shopping.model.ValidateGroups;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author tangx
 * @date 2022/7/28 10:15
 */
@Data
public class MoldDto {

    @NotNull(groups = {ValidateGroups.Update.class}, message = "id不能为空")
    private Integer id;

    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "name不能为空")
    private String name;

    /**
     * 运营人员
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "op不能为空")
    private String op;

    /**
     * 设计人员
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "designer不能为空")
    private String designer;

    /**
     * 模板类型
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "moldType不能为空")
    private String moldType;

    /**
     * 封面图片
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "coverImg不能为空")
    private String coverImg;

    /**
     * 模板描述
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "desc不能为空")
    private String description;

    /**
     * 配置项
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "config不能为空")
    private String config;

    /**
     * 模板url
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "url不能为空")
    private String url;

}
