package com.bxm.shopping.model.dto;

import com.bxm.shopping.model.ValidateGroups;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author tangx
 * @date 2022/9/20 10:15
 */
@Data
public class ProductComponentDto {

    @NotNull(groups = {ValidateGroups.Update.class}, message = "id不能为空")
    private Integer id;

    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "name不能为空")
    private String name;

    /**
     * 组件标识
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "code不能为空")
    private String code;

    /**
     * 组件类型
     */
    @NotNull(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "componentType不能为空")
    private Integer componentType;

    /**
     * 产品运营
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "op不能为空")
    private String op;

    /**
     * 封面图片
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "backImg不能为空")
    private String coverImg;

    /**
     * 是否多次渲染 0.否 1.是
     */
    @NotNull(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "isMultipleRender不能为空")
    private Integer isMultipleRender;

    /**
     * 配置项
     */
    @NotBlank(groups = {ValidateGroups.Add.class, ValidateGroups.Update.class}, message = "config不能为空")
    private String config;

}
