package com.bxm.shopping.model.dto;


import com.google.common.collect.Lists;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class UserOrderDto implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 产品ID
     */
    @NotNull(message = "商品id为空")
    private Integer productId;
    /**
     * 单价
     */
    private BigDecimal unitPrice;
    /**
     * 数量
     */
    private Integer count;

    private String userName;

    private String userMobile;

    private String province;

    private String city;

    /**
     * 区
     */
    private String region;

    private String address;

    private String ip;

    private String ua;

    private String channel;

    /**
     * 渠道订单id（例如bxmId）
     */
    private String channelOrderId;

    /**
     * 订单来源 （0. 投放 1.返回拦截 2.下单成功页）
     */
    private Integer sourceType;

    private String callTime;

    /**
     * 商品规格名称
     */
    private String productUnitName;

    /**
     * 商品款式 &号分隔 eg. 颜色:蓝色&尺寸:L
     */
    private String productStyle;

    /**
     * 商品规格id
     */
    private String productUnitId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 短信验证码
     */
    private String smsCaptcha;

    /**
     * 是否需要验证码
     */
    private Integer needSmsCaptcha;

    /**
     * 支付方式 1.支付宝 2.微信
     */
    private Integer payType;

    /**
     * 微信环境需要code
     */
    private String weixinCode;

    /**
     * 客户端类型，0：h5，1：app，2：微信
     */
    private Byte clientType;

    private String host;

    /**
     * 省编号
     */
    private String provinceCode;

    /**
     * 市编号
     */
    private String cityCode;

    /**
     * 区编号
     */
    private String regionCode;

    private Integer idCardVerify;

    private Integer advertiserId;

    /**
     * 命中规则
     */
    private String hitMarks;

    /**
     * 命中的敏感词汇  逗号分隔
     */
    private String hitRiskWords;


    /**
     * 选择的规格项
     */
    private String optionSelected;

    /**
     * 命中敏感词的集合
     */
    private List<String> hitRiskWordList = Lists.newArrayList();

    /**
     * 标记的类型集合
     */
    private List<Integer> hitMarkList = Lists.newArrayList();


    /**
     * 是否需要身份验证
     * @return
     */
    public boolean needIdCardVerify() {
        return idCardVerify != null && idCardVerify.equals(1);
    }

    public String getAddressLimitKey() {
       return this.getProvince() + "-" + this.getCity() + "-" + this.getRegion();
    }


}
