package com.bxm.shopping.model.query;


import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 产品表
 * </p>
 *
 * @author lala
 * @since 2020-07-15
 */
@Data
public class ProductQuery extends CommonQuery implements Serializable {
    /**
     * 产品id
     * 产品名称
     * 广告主id
     * 广告主名称
     * 状态
     **/
    private Integer productId;
    private String productName;
    private String advertiserId;
    private String advertiserName;
    private Integer productType;
    /**
     * 模板类型：根据productType区分互动或常规模板类型
     */
    private String moldType;
    private Integer status;

    /**
     * 平台类型：1.变现猫 2.触宝
     */
    private Integer platformType;

    /**
     * 商户id/名称
     */
    private String advertiserKeyword;

    /**
     * 商品id/名称
     */
    private String productKeyword;

    /**
     * 广告运营
     */
    private String ae;

    private String moldKeyword;
    /**
     * id列表
     */
    private List<Integer>  ids;
}
