package com.bxm.shopping.model.query;


import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * @author lala
 * @since 2020-07-15
 */
@Data
public class UserOrderQuery extends CommonQuery implements Serializable {

    // 运营后台
    public final static Integer PLATFORM_OP = 1;
    // 商户后台
    public final static Integer PLATFORM_MERCHANT = 2;


    /**
     * 产品id /名称
     * 广告主id/名称
     * 状态
     * 订单编号
     **/
    private String productKeywords;
    private String advertiserKeywords;
    private Integer status;
    private String orderNum;

    private String userName;
    private String mobile;
    private String startTime;
    private String endTime;

    /**
     * 订单来源
     */
    private Integer sourceType;

    private List<Integer> advertiserList;

    /**
     * 商户后台的广告主
     */
    private Integer advertiserId;

    /**
     * 导出时需要传
     */
    private String token;

    /**
     * 1.运营后台 2.商户后台
     */
    private Integer platform;



    /**
     * 支付状态：0.未支付 1.已支付
     */
    private Integer payStatus;


    /**
     * 第三方支付单号
     */
    private String payNum;

    /**
     * 1.支付宝 2.微信
     */
    private Integer payType;

    /**
     * 支付时间  开始
     */
    private String payStartTime;

    /**
     * 支付时间  结束
     */
    private String payEndTime;

    private List<String> productIdList;


    /**
     * 是否为运营平台
     * @return
     */
    public boolean isOpPlatform() {
       return Objects.equals(UserOrderQuery.PLATFORM_OP, platform);
    }

    /**
     * 是否为商户平台
     * @return
     */
    public boolean isMerchantPlatform() {
        return Objects.equals(UserOrderQuery.PLATFORM_MERCHANT, platform);
    }


}
