package com.bxm.shopping.model.vo;


import com.bxm.shopping.model.dto.DownloadConfig;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 产品表
 * </p>
 *
 * @author lala
 * @since 2020-07-15
 */
@Data
public class ProductVo implements Serializable {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 广告主id
     */
    private Integer advertiserId;

    private String advertiserName;

    /**
     * 商品标题
     */
    private String productTitle;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 模板id
     * 模板url
     */
    private Integer templateId;
    private String templateUrl;

    /**
     * 头部图片
     */
    private String headImgs;

    /**
     * 中间图片
     */
    private String middleImgs;

    /**
     * 尾部图片
     */
    private String bottomImgs;

    /**
     * 内容区四 图片
     */
    private String fourthContentImgs;

    /**
     * 可下跳图片所在位置 ，从0开始，逗号分隔
     */
    private String headImgsButton;

    /**
     * 底部导航栏图
     */
    private String bottomNavigationImgs;

    /**
     * 返回拦截开关（1 开 0关）
     */
    private Integer interceptSwitch;

    /**
     * 返回拦截产品id
     */
    private Integer interceptProductId;

    /**
     * 返回拦截内容
     */
    private String interceptPopupContent;

    /**
     * 返回拦截url
     */
    private String interceptPopupUrl;

    /**
     * 成功页商品id
     */
    private Integer successProductId;


    /**
     * 成功页商品url
     */
    private String successProductUrl;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 原价（划线价）
     */
    private BigDecimal marketPrice;

    /**
     * 客服电话
     */
    private String mobile;

    /**
     * 1待上架  2 已上架  3已下架
     */
    private Integer status;

    private Date createTime;


    private String errorUrl;

    /**
     * 平台类型：1.变现猫 2.触宝
     */
    private Integer platformType;

    /**
     * 转化id
     */
    private String transId;

    private String trackingId;

    /**
     * 网页title
     */
    private String pageTitle;

    /**
     * 是否多规格：1是 0否
     */
    private Integer isMultiPrice;

    /**
     * 按钮文案
     */
    private String buttonContent;

    /**
     * 是否需要备注：1是 0否
     */
    private Integer showRemark;

    /**
     * 是否显示价格：1是 0否
     */
    private Integer showPrice;

    /**
     * 吸底按钮是否倒计时
     */
    private Integer isCountdown;

    /**
     * 吸底按钮文案
     */
    private String suctButtonContent;

    /**
     * 规格配置
     */
    private String productUnits;

    /**
     * 中间页背景图
     */
    private String middlePageBackImg;

    /**
     * 中间页弹窗图
     */
    private String middlePagePopupsImg;

    /**
     * 中间页多少秒出现弹窗
     */
    private Double middlePagePopupsTime;

    /**
     * 中间页跳转url
     */
    private String middlePageJumpUrl;

    /**
     * 中间页背景颜色
     */
    private String middlePageBackColor;

    /**
     * 中间页自动跳转 0.关闭 1.开启
     */
    private Integer middlePageAutoJump;

    /**
     * 中间页自动跳转秒数
     */
    private Double middlePageAutoJumpTime;

    /**
     * 表单数
     */
    private Integer formAmount;

    /**
     * 表单字段（多个用逗号分开）：1.产品名称 2.姓名 3.手机号 4.身份证 5.短信验证码 6.地址 7.接电话时间
     * 8.备注项 9.我已阅读(电信) 10.我已阅读（联通） 11.我已阅读（移动） 12.信息查询授权书 13.规格 14.宽带业务协议 15.活动细则 16.个人信息授权保护声明
     */
    private String formFields;

    /**
     * 协议名称
     */
    private String protocolTitle;

    private String protocolContent;

    /**
     * 是否显示轮播 0.不显示 1.显示
     */
    private Integer showCarousel;

    /**
     * 轮播内容
     */
    private String carouselContent;

    /**
     * 表单边框底色
     */
    private String formFrameColor;

    /**
     * 下单成功页标题
     */
    private String successPageTitle;

    /**
     * 下单成功页副标题
     */
    private String successPageSubtitle;

    /**
     * 下单成功页链接
     */
    private String successPageUrl;

    /**
     * 多商品配置 Json格式
     */
    private String multiProductConfig;

    /**
     * 产品外部编号
     */
    private String productExternalCode;

    /**
     * 是否需要六律
     */
    private Integer isLiulv;

    /**
     * 下单年龄限制开始
     */
    private String ageLimitStart;

    /**
     * 下单年龄限制结束
     */
    private String ageLimitEnd;

    /**
     * 弹窗类型 0.无弹窗 1.一级弹窗 2.二级弹窗
     */
    private Integer popupType;

    /**
     * 第一级弹窗图片
     */
    private String firstPopupImg;

    /**
     * 第二级弹窗图片
     */
    private String secondPopupImg;

    /**
     * 弹窗几秒后出现
     */
    private Double popupShowTime;

    /**
     * 弹窗几秒后跳转
     */
    private Double popupJumpTime;

    /**
     * 短信验证码签名
     */
    private String captchaTitle;


    /**
     * 内容区一的显示类型 1.轮播(有视频) 2.瀑布流
     */
    private Integer headContentType;

    /**
     * 内容区一视频url
     */
    private String headVideos;

    /**
     * 返回拦截弹窗图片
     */
    private String interceptPopupImg;

    /**
     * 返回拦截广告位id
     */
    private String interceptPositionId;

    /**
     * 返回拦截广告位链接
     */
    private String interceptPositionLink;

    /**
     * 下单成功页按钮点击类型：0.无 1.返回上一页 2.跳转链接
     */
    private Integer successClickType;

    /**
     * 下单成功页banner图
     */
    private String successBannerUrl;

    /**
     * 下单成功页跳转广告位id
     */
    private String successPositionId;

    /**
     * 下单成功页跳转广告位链接
     */
    private String successPositionLink;

    /**
     * 提交按钮类型 1.文本  2.图片
     */
    private Integer submitButtonType;

    /**
     * 提交按钮图片url
     */
    private String submitButtonImg;

    /**
     * 自动填写地址 0.关闭 1.根据IP
     */
    private Integer autoAddress;

    /**
     * 表单标题
     */
    private String formTitle;

    /**
     * 倒计时展示 0.关闭 1.开启
     */
    private Integer showCountdown;

    /**
     * 客户端当前ip
     */
    private String currentIp;

    /**
     * 摇奖配置json字符串：background, bestAward, award1, award2
     */
    private String lotteryConfig;

    /**
     * 折叠状态
     */
    private Integer foldStatus;


    /**
     * 中间页弹窗关闭按钮  0.不存在 1.存在
     */
    private Integer popupsCloseButton;

    /**
     * 中间页弹窗延迟出现时间 秒数
     */
    private Double popupsDelayTimes;


    /**
     * 关键字屏蔽提示文案
     */
    private String filterKeywordHint;

    /**
     * 地址库
     */
    private String addressLibrary;

    /**
     * 地址关键字 逗号分隔
     */
    private String addressBanKeyword;

    /**
     * 下单地区限制
     */
    private String limitRegion;

    /**
     * 下单地区限制 黑白名单 0黑名单 1.白名单
     */
    private Integer limitRegionBlackOrWhite;

    /**
     * 用户每天限制几单
     */
    private Integer orderLimit;

    /**
     * 问卷配置
     */
    private String questionConfig;

    /**
     * 下单限制天数范围
     */
    private Integer orderLimitTimeRange;

    /**
     * 地址库id
     */
    private Integer addressLibraryId;

    /**
     * 地址库文件地址
     */
    private String addressLibraryUrl;

    /**
     * 点击弹窗 跳转位置 1.表单置顶 2.首图置顶
     */
    private Integer popupJumpPosition;
    /**
     * 表单字段（多个用逗号分开） 折叠第二层 同form_fields
     */
    private String formSecondFoldFields;
    /**
     * 表单字段（多个用逗号分开） 折叠第三层 同form_fields
     */
    private String formThirdFoldFields;

    /**
     * 表单字段（多个用逗号分开） 折叠其他字段 同form_fields
     */
    private String formOtherFoldFields;

    /**
     * 表单折叠状态 0.不折叠 1.折叠
     */
    private Integer formFoldStatus;

    private LimitStrategy limitStrategy;


    /**
     * 投放环境  1.H5 2.IOS+安卓
     */
    private Integer visitType;

    /**
     * 下载类配置
     */
    private DownloadConfig downloadConfig;

    /**
     * 返回拦截按钮文案1
     */
    private String interceptButtonTxt1;

    /**
     * 返回拦截按钮文案2
     */
    private String interceptButtonTxt2;

    /**
     * 返回拦截跳转开关 0.不跳转 1.跳转
     */
    private Integer interceptJumpStatus;

    /**
     * 下单成功页弹窗配置  0.文字 1.图片
     */
    private Integer successPageType;

    /**
     * 下单成功页弹窗图片url
     */
    private String successImgUrl;

    /**
     * 下单成功页跳转开关  0.不跳转 1.跳转
     */
    private Integer successJumpStatus;

    /**
     * 动效弹窗模组id
     */
    private Integer dynamicPopupTemplateId;

    /**
     * 动效弹窗配置json格式
     */
    private String dynamicPopupConfig;

    /**
     * 下单限制生效广告主 0.同一广告主 1.多个广告主
     */
    private Integer limitOrderAdvertiserType;

    /**
     * 限制多个广告主时的广告主id, 逗号分开
     */
    private String limitOrderAdvertiserId;

    /**
     * 用户信息授权 0.不勾选 1.勾选
     */
    private Integer userAuthCheckStatus;

    /**
     * 下单短信开关 0.关 1.开
     */
    private Integer orderSmsStatus;

    /**
     * 下单短信内容
     */
    private String orderSmsContent;

    /**
     * 表单弹窗样式配置
     */
    private String formPopupConfig;

    /**
     * 规格配置 json字符串（optionName：规格名称  options：规格项）
     */
    private String multiOptionConfig;



    /**
     * 活动规则显示状态 0.不显示 1.显示
     */
    private Integer activityRuleStatus;

    /**
     * 活动规则图标
     */
    private String activityRuleIcon;

    /**
     * 活动规则标题
     */
    private String activityRuleTitle;

    /**
     * 活动规则内容
     */
    private String activityRuleContent;

    /**
     * 活动规则跳转按钮文案
     */
    private String activityRuleButtonContent;

    /**
     * 弹窗几秒后出现 一级
     */
    private Double popupShowTimeFirst;


    /**
     * 提交按钮文案 倒计时组件：0.关 1.开
     */
    private Integer submitButtonCountdownStatus;

    /**
     * 表单标题 倒计时组件：0.关 1.开
     */
    private Integer formTitleCountdownStatus;

    /**
     * 跑马灯开关：0.关 1.开
     */
    private Integer marqueeStatus;

    /**
     * 跑马灯文案
     */
    private String marqueeContent;

    /**
     * 落地页表单类型 0.无 1.首页表单 2.弹窗表单
     */
    private Integer landingPageFormType;

    /**
     * 关联的协议，多个用逗号分开
     */
    private String agreements;

    /**
     * 关联的协议数组
     */
    private List<AgreementSimpleVo> agreementList;

    /**
     * 是否展示客服图片  0.否 1.是
     */
    private Integer showCustomerService;

    /**
     * 客服图标
     */
    private String customerServiceImg;

    /**
     * 客服链接
     */
    private String customerServiceLink;

    /**
     * 底部声明
     */
    private String bottomContent;

    /**
     * 其他结果url
     */
    private String otherResultUrl;

    /**
     * 小程序path
     */
    private String miniProgramPath;

    /**
     * 小程序原始id
     */
    private String miniProgramId;

    /**
     * 最大奖品图片
     */
    private String bestAwardImg;

    /**
     * 转盘自动参与 0.手动  1.自动
     */
    private Integer autoTurntable;

    /**
     * 视频配置
     */
    private String videoConfig;

    /**
     * 1.常规 2.互动
     */
    private Integer productType;

    /**
     * 广告行业标签
     */
    private Integer adTag;

    /**
     * 广告行业标签名称
     */
    private String adTagName;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 模板类型
     */
    private String moldType;

    /**
     * 互动模板id
     */
    private Integer moldId;

    /**
     * 商品模板配置
     */
    private String productMoldConfig;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 声明位置 0.不前置 1.顶部滚动前置 2.底部滚动前置
     */
    private Integer statementPositionType;

    /**
     * 广告运营
     */
    private String ae;

    /**
     * logo 图片
     */
    private String logoImg;

    /**
     * 是否有中间页 0.否  1是
     */
    private Integer existMiddlePage;

    /**
     * 二维码页背景颜色
     */
    private String qrCodePageBackColor;

    /**
     * 二维码页图
     */
    private String qrCodePageImg;

    /**
     * 表单页背景色值
     */
    private String formPageBackColor;

    /**
     * 表单页面图
     */
    private String formPageImg;

    /**
     * 中间页关闭时间
     */
    private Double middlePageCloseTime;

    /**
     * 互动模板名称
     */
    private String moldName;

    /**
     * 组价id组合键
     */
    private String componentUnionKey;

    /**
     * 麒麟域名组ID
     */
    private String kylinGroupId;

    /**
     * 是否显示表单 0.否 1.是
     */
    private Integer showForm;

    /**
     * 下载悬浮按钮图标
     */
    private String downloadFloatImg;

    /**
     * 底部浮层按钮图标
     */
    private String downloadButtonFloatImg;

    /**
     * 落地页链接
     */
    private String landingPageUrl;
    /**
     * 落地页麒麟域名组
     */
    private String lpKylinGroupId;

    /**
     * 下单限制策略
     */
    @Data
    public static class LimitStrategy{

        private String limitPhoneValue;

        private String limitIdCardValue;

        private Integer limitPhoneStatus;

        private Integer limitIdCardStatus;

        private Integer limitAddressStatus;

        private Integer limitNameStatus;

        private Integer limitIpBlackStatus;

        private Integer limitAddressTailStatus;
    }

}

