package com.bxm.shopping.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lala
 * @since 2020-07-15
 */
@Data
public class UserOrderVo implements Serializable {

    private static final long serialVersionUID = 1L;
    private Integer id;

    /**
     * 广告主id
     */
    private Integer advertiserId;

    private String advertiserName;
    /**
     * 产品ID
     */
    private Integer productId;

    /**
     * 商品标题
     */
    private String productTitle;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 数量
     */
    private Integer count;

    /**
     * 总价
     */
    private BigDecimal totalPrice;

    /**
     * 用户姓名
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String region;

    /**
     * 地址
     */
    private String address;

    /**
     * 状态（1待审核 2待发货 3已发货 4交易成功 5交易失败）
     */
    private Integer status;

    private String ip;

    private String ua;

    /**
     * 渠道号
     */
    private String channel;

    /**
     * 渠道订单id（例如bxmId）
     */
    private String channelOrderId;

    private Date createTime;

    private Date modifyTime;

    /**
     * 物流单号
     */
    private String trackingNum;

    /**
     * 物流公司（顺丰：shunfeng，京东：jd，中通：zhongtong，申通：shentong，圆通：yuantong，韵达：yunda）
     */
    private String expressCompany;

    /**
     * 发货时间
     */
    private Date sendTime;

    /**
     * 订单来源 （0. 投放 1.返回拦截 2.下单成功页）
     */
    private Integer sourceType;

    /**
     * 接听电话时间
     */
    private String callTime;

    /**
     * 商品规格
     */
    private String productUnit;

    /**
     * 商品款式 &号分隔 eg. 颜色:蓝色&尺寸:L
     */
    private String productStyle;

    /**
     * 备注
     */
    private String remark;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 支付状态：0.未支付 1.已支付
     */
    private Integer payStatus;

    /**
     * 第三方支付单号
     */
    private String payNum;

    /**
     * 1.支付宝 2.微信
     */
    private Integer payType;

    /**
     * 支付完成时间
     */
    private Date payCompleteTime;

    /**
     * 命中规则：逗号分开 1.姓名超过7位 2.姓名敏感词汇 3.地址敏感词汇 4.风控前置ip作弊流量
     */
    private String hitMarks;

    /**
     * 命中的敏感词汇  逗号分隔
     */
    private String hitRiskWords;

    /**
     * 行为类型 1.入库 2.充值 3.激活
     */
    private Integer behaviorType;

    /**
     * 券id
     */
    private String ticketId;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 选择的规格项
     */
    private String optionSelected;
}
