package com.bxm.shopping.web.controller;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;

import java.io.*;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * excel地址库转json格式
 * @author tangx
 * @date 2021/8/2 16:58
 */
@Slf4j
@Controller
public class AddressExcelListProcessor {

    /**
     * 适用于每行为区级的 转化树结构json
     * 例如
     * 1行.省-市-区
     * 2行.省-市-区
     * @throws FileNotFoundException
     */
    @SneakyThrows
    public static List<Province> transformAddressTree(List<ImportVo> importVos)  {

        // 将对象分组成 省-区对象   将对象分组成市-县对象
        // 省-县 map
        Map<String, List<ImportVo>> provinceMap = importVos.stream().collect(Collectors.groupingBy(i -> i.getProvinceName(),  LinkedHashMap::new, Collectors.toList()));

        List<Province> resultList = new ArrayList<>(50);
        provinceMap.forEach((k, v) -> {
            // 这个省的 市-区 map
            Map<String, List<ImportVo>> cityMap = v.stream().collect(Collectors.groupingBy(i -> i.getCityName(),  LinkedHashMap::new, Collectors.toList()));

            Province provinceData = new Province();
            provinceData.setName(k);
            List<City> cityResult = new ArrayList<>();

            cityMap.forEach((cityName,i) -> {
                City cityData = new City();
                cityData.setName(cityName);
                List<ImportVo> regionimportVos = cityMap.get(cityName);
                List<Region> regionResult = new ArrayList<>();
                for (ImportVo regionimportVo : regionimportVos) {
                    Region regionData = new Region();
                    regionData.setName(regionimportVo.getRegionName());
                    regionResult.add(regionData);
                }
                cityData.setChildren(regionResult);
                cityResult.add(cityData);
            });
            provinceData.setChildren(cityResult);
            resultList.add(provinceData);
        });
        return resultList;
    }


    @Data
    public static class ImportVo implements Serializable {
        private static final long serialVersionUID = -8923767200269229961L;

        @ExcelProperty("省")
        private String provinceName;
        @ExcelProperty("市")
        private String cityName;
        @ExcelProperty("区/县")
        private String regionName;
    }


    @Data
    public static class Province implements Serializable {

        @JSONField(ordinal = 1)
        private String name;
        @JSONField(ordinal = 2)
        private List<City> children;

    }


    @Data
    public static class City implements Serializable{
        @JSONField(ordinal = 1)
        private String name;
        @JSONField(ordinal = 2)
        private List<Region> children;
    }


    @Data
    public static class Region implements Serializable {
        private String name;
    }

}