package com.bxm.shopping.web.controller;

import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.shopping.integration.adsmedia.AdsmediaIntegration;
import com.bxm.util.dto.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author tangx
 * @date 2021/5/26 14:41
 */
@RestController
@RequestMapping("/position")
public class AdsmediaController {

    @Autowired
    private AdsmediaIntegration adsmediaIntegration;

    @GetMapping("/getPositionById")
    public ResponseEntity getPositionById(@RequestParam("positionId") String positionId) {
        AppEntranceAdRO appEntranceAdRO = adsmediaIntegration.findByPositionId(positionId);
        return ResponseEntity.ok(appEntranceAdRO);
    }

    @RequestMapping(value = "/getAppEntranceCodeName", method = RequestMethod.GET)
    public ResultModel<Map<String,String>> getAppEntranceCodeName() {
        ResultModel<Map<String,String>> resultModel = new ResultModel<>();
        resultModel.setReturnValue(adsmediaIntegration.getAppEntranceCodeName());
        return resultModel;
    }
}
