
package com.bxm.shopping.web.controller;


import com.bxm.shopping.integration.advertiser.model.AdvertiserShoppingDto;
import com.bxm.shopping.service.AdvertiserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * <p>
 * 广告主商户相关接口
 * </p>
 *
 * @author lala
 * @since 2020-07-14
 */
@Slf4j
@RestController
public class AdvertiserController {
    @Resource
    AdvertiserService advertiserService;

    /**
     * 根据参数查找分页接口
     *
     * @param advertiserShoppingDto
     * @return
     */
    @RequestMapping(value = "/advertiser/getPageList", produces = "application/json")
    public ResponseEntity getPageList(AdvertiserShoppingDto advertiserShoppingDto) {
        return ResponseEntity.ok(advertiserService.getPageList(advertiserShoppingDto));
    }

    @RequestMapping(value = "/advertiser/updateShoppingStatus", produces = "application/json")
    public ResponseEntity updateShoppingStatus(@RequestParam(value = "id") Integer id,
                                               @RequestParam(value = "isShopping") Integer isShopping) {
        return ResponseEntity.ok(advertiserService.updateShoppingStatus(id, isShopping));
    }

    @RequestMapping(value = "/advertiser/updateMerchantEnable", produces = "application/json", method = RequestMethod.POST)
    public ResponseEntity updateMerchantEnable(@RequestParam(value = "id") Integer id,
                                               @RequestParam(value = "isEnableMerchant") Byte isEnableMerchant) {
        return ResponseEntity.ok(advertiserService.updateMerchantEnable(id, isEnableMerchant));
    }
}
