package com.bxm.shopping.web.controller;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.dal.entity.Agreement;
import com.bxm.shopping.model.ValidateGroups;
import com.bxm.shopping.model.dto.AgreementDto;
import com.bxm.shopping.model.dto.AgreementSearchDto;
import com.bxm.shopping.model.vo.AgreementVo;
import com.bxm.shopping.service.IAgreementService;
import com.bxm.shopping.service.util.RequestUtils;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * <p>
 * 协议表 前端控制器
 * </p>
 *
 * @author tangxiao
 * @since 2022-04-19
 */
@RestController
@RequestMapping("/agreement")
public class AgreementController {

    @Autowired
    private IAgreementService agreementService;


    /**
     * 协议列表
     * @param searchDto
     * @return
     */
    @GetMapping("/list")
    public ResponseModel list(AgreementSearchDto searchDto) {
        IPage<AgreementVo> list = agreementService.list(searchDto);
        return ResponseModelFactory.SUCCESS(list);
    }

    /**
     * 协议列表
     * @param searchDto
     * @return
     */
    @GetMapping("/listSimple")
    public ResponseModel listSimple(AgreementSearchDto searchDto) {
        return ResponseModelFactory.SUCCESS(agreementService.listSimple(searchDto));
    }

    /**
     * 根据id查询协议
     * @return
     */
    @GetMapping("/get")
    public ResponseModel getById(@RequestParam("id") Integer id) {
        return ResponseModelFactory.SUCCESS(agreementService.getById(id));
    }


    @PostMapping("/create")
    public ResponseModel create(@RequestBody @Validated({ValidateGroups.Add.class}) AgreementDto agreementDto) {
        LambdaQueryWrapper<Agreement> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(Agreement::getName, agreementDto.getName())
                .eq(Agreement::getAdvertiserId, agreementDto.getAdvertiserId());
        if (agreementService.count(queryWrapper) > 0) {
            throw new ShoppingException("名称已存在");
        }

        Agreement agreement = new Agreement();
        BeanUtils.copyProperties(agreementDto, agreement);
        agreement.setCreateTime(new Date());
        agreement.setCreateUser(RequestUtils.getCurrentUserName());
        agreement.setUpdateTime(new Date());
        agreementService.save(agreement);
        return ResponseModelFactory.SUCCESS();
    }

    @PostMapping("/update")
    public ResponseModel update(@RequestBody @Validated(ValidateGroups.Update.class) AgreementDto agreementDto) {
        LambdaQueryWrapper<Agreement> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(Agreement::getName, agreementDto.getName())
                .eq(Agreement::getAdvertiserId, agreementDto.getAdvertiserId())
                .ne(Agreement::getId, agreementDto.getId());
        if (agreementService.count(queryWrapper) > 0) {
            throw new ShoppingException("名称已存在");
        }

        Agreement agreement = new Agreement();
        BeanUtils.copyProperties(agreementDto, agreement);
        agreement.setUpdateTime(new Date());
        agreement.setUpdateUser(RequestUtils.getCurrentUserName());
        agreementService.updateById(agreement);
        return ResponseModelFactory.SUCCESS();
    }
}



