package com.bxm.shopping.web.controller;

import com.bxm.shopping.common.enums.FileType;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.common.utils.FileTypeJudge;
import com.bxm.shopping.common.utils.InputStreamUtil;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.*;


@Slf4j
@RestController
@RequestMapping("/upload")
public class FileUploadController {

    private String bucketName ="bxm-guide";
    //@Value("${oss.fileHost}")
    private String fileHost ="https://buyimg.bianxianmao.com/";
    // @Value("${oss.accessKeyId}")
    private String accessKeyId ="LTAIdRl4etA0hXJt";
    // @Value("${oss.secret}")
    private String secret ="oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    /**
     * 允许上传的图片类型
     */
    private final static Set<String> ALLOW_IMG_TYPE_SET = Sets.newHashSet(
            FileType.JPG.getCode(),
            FileType.PNG.getCode(),
            FileType.GIF.getCode());
    /**
     * 最大上传图片 3m
     */
    private final static long MAX_UPLOAD_IMG_SIZE = 3 * 1024 * 1024L;

    @Autowired
    private HttpFileManager httpFileManager;

    private final static ExecutorService SINGLE_THREAD_POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<>(),
            new NamedThreadFactory("upload-img"));

    @PreDestroy
    public void destroy() {
        SINGLE_THREAD_POOL.shutdown();
        try {
            if (!SINGLE_THREAD_POOL.awaitTermination(30, TimeUnit.SECONDS)) {
                log.error("termination has timeout");
            }
        } catch (InterruptedException e) {
            log.error("destroy:", e);
        }
    }
    /**
     * 上传图片
     *
     * @param file
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/img", method = {RequestMethod.POST})
    public String uploadImg(@RequestParam("img") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new ShoppingException("上传文件不能为空！");
        }
        if (file.getSize() > MAX_UPLOAD_IMG_SIZE) {
            throw new ShoppingException("上传文件不能大于3M！");
        }
        // FileTypeJudge.getTypeByInputStream 会关闭文件流
        FileType fileType = FileTypeJudge.getTypeByInputStream(InputStreamUtil.copy(file.getInputStream()));
        if (null == fileType || !ALLOW_IMG_TYPE_SET.contains(fileType.getCode())) {
            throw new ShoppingException("请上传正确类型的文件！");
        }
        // 前端批量传多张会报错， 所以做了每次只传一张的处理
        Future<String> future = SINGLE_THREAD_POOL.submit(() -> {
            try {
                return httpFileManager.upload(new HttpFileRequest(file));
            } catch (Exception e) {
                log.error(e.getMessage(), e);
                throw new ShoppingException("上传失败");
            }
        });

        String uploadPath;
        try {
            uploadPath = future.get(6, TimeUnit.SECONDS);
        } catch (TimeoutException e) {
            future.cancel(true);
            throw new ShoppingException("上传超时");
        } catch (Exception e) {
            future.cancel(true);
            throw new ShoppingException("上传失败");
        }
        log.info("img upload success, the url : {} ", uploadPath);
        return uploadPath;
    }


    /**
     * 上传视频
     *
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/video", method = { RequestMethod.POST })
    public ResultModel<List<String>> uploadVideo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultModel<List<String>> resultModel = new ResultModel<List<String>>();

        // 创建一个通用的多部分解析器
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<String> files = new ArrayList<>();
        // 判断 request 是否有文件上传,即多部分请求
        if (multipartResolver.isMultipart(request)) {
            // 转换成多部分request
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            // 取得request中的所有文件名
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                // 取得上传文件
                MultipartFile file = multiRequest.getFile(iter.next());
                if (file != null) {
                    // 取得当前上传文件的文件名称
                    String fileName = file.getOriginalFilename();
                    // 如果名称不为空,说明该文件存在，否则说明该文件不存在
                    if (fileName.trim() != "") {
                        File newFile = new File(fileName);
                        FileOutputStream outStream = new FileOutputStream(newFile); // 文件输出流用于将数据写入文件
                        outStream.write(file.getBytes());
                        outStream.close(); // 关闭文件输出流
                        file.transferTo(newFile);
                        // 上传到阿里云
                        files.add(AliOSSUtil.upload(accessKeyId, secret, newFile, bucketName, fileHost, null));
                        newFile.delete();
                    }
                }
            }
        }
        //上传失败提示
        if(files.isEmpty()){
            resultModel.setErrorDesc("系统异常,上传文件失败");
            resultModel.setReturnValue(null);
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(files);
        log.info("file upload success! url:{}", files.get(0));
        return resultModel;
    }
}
