package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.enums.OrderType;
import com.bxm.shopping.common.enums.TrackStatusEnum;
import com.bxm.shopping.dal.entity.UserOrder;
import com.bxm.shopping.integration.kuaidi.KuaidiIntegration;
import com.bxm.shopping.integration.kuaidi.model.SubscribeResp;
import com.bxm.shopping.integration.kuaidi.model.TrackInfoVo;
import com.bxm.shopping.integration.kuaidi.utils.SignUtils;
import com.bxm.shopping.service.IUserOrderService;
import com.bxm.warcar.utils.JsonHelper;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author tangx
 * @date 2020/8/21 17:30
 */
@Slf4j
@RestController
public class KuaidiController {
    @Resource
    IUserOrderService orderService;

    /**
     * 获取物流信息
     * @return
     */
    @RequestMapping(value = "/order/getTrackInfo", produces = "application/json", method = RequestMethod.GET)
    public ResponseEntity getTrackInfo(@RequestParam("id") Integer id) {
        TrackInfoVo vo = orderService.getTrackInfo(id);
        return ResponseEntity.ok(vo);
    }

    /**
     * 快递100回调接口。
     * 订阅推送处理(参照)
     * 订阅成功后，如果该快递单号有轨迹（包括已经签收的单），快递100将会在15分钟-4个小时推送；后面将会4个小时跟踪一次，跟踪到有轨迹变化则推送；
     * 如果订阅成功后，3天查无结果（录错单/快递公司错了/揽收比较晚），快递100将会推送3天查无结果，可以继续重新订阅。
     *
     * 回调接口支持自定义参数,比如订阅时回调地址填写的是 http://www.xxx.com?orderId=1233333
     * 可以通过下面这种方式获取到orderId： String orderId = request.getParameter("orderId");
     *
     * 返回值必须是下面这样的格式，否则快递100将认为该推送失败，快递100将会重试3次该推送，时间间隔35分钟；
     * 成功结果返回例子： {"result":true,"returnCode":"200","message":"提交成功"}
     * @param request
     * @return
     */
    @RequestMapping(value = "/kuaidi/callback", method = RequestMethod.POST)
    public SubscribeResp callback(HttpServletRequest request) {
        String param = request.getParameter("param");
        String sign = request.getParameter("sign");
        String orderNum = request.getParameter("orderNum");
        String trackingNum = request.getParameter("trackingNum");
        log.info("【快递100】订阅推送数据|{}|{}|{}",param, sign, orderNum);
        //订阅时传的salt,没有可以忽略
        String ourSign = SignUtils.sign(param + KuaidiIntegration.SALT);

        //加密如果相等，属于快递100推送；否则可以忽略掉当前请求
        if (!ourSign.equals(sign)) {
            return null;
        }
        JSONObject paramJson = JsonHelper.convert(param, JSONObject.class);
        JSONObject lastResult = (JSONObject) paramJson.get("lastResult");
        String state = StringUtil.toString(lastResult.get("state"));
        if (StringUtils.isBlank(state)) {
            return null;
        }

        // 用快递单号查出 查出所有订单信息
        List<UserOrder> userOrdersByTrackingNum = orderService.findListByOneParam(UserOrder.TRACKING_NUM, trackingNum);

        if (CollectionUtils.isEmpty(userOrdersByTrackingNum)) {
            log.warn("【快递100】订阅推送回调的快递单号有误,orderNum:{}，trackingNum:{}", orderNum, trackingNum);
            return successReturn();
        }

        for (UserOrder order : userOrdersByTrackingNum) {

            // 订单状态不是已发货直接返回
            if (!order.getStatus().equals(OrderType.THREE.getCode())) {
                continue;
            }
            // 如果传过来的状态是 3签收 7转单 则可以更新订单为交易成功； 如果是4退签 14拒签 可以更新为交易失败
            if (state.equals(TrackStatusEnum.QIANSHOU.getCode()) || state.equals(TrackStatusEnum.ZHUANDAN.getCode()) ) {
                orderService.updateStatus(order.getId(), OrderType.FOUR.getCode());
                log.info("【快递100】订阅回调结果：订单更新为交易成功, orderNum: {}", orderNum);
            }
            if (state.equals(TrackStatusEnum.TUIQIAN.getCode()) || state.equals(TrackStatusEnum.JUQIAN.getCode()) ) {
                orderService.updateStatus(order.getId(), OrderType.FIVE.getCode());
                log.info("【快递100】订阅回调结果：订单更新为交易失败, orderNum: {}", orderNum);
            }
        }
        return successReturn();
    }

    public SubscribeResp successReturn() {
        SubscribeResp subscribeResp = new SubscribeResp();
        subscribeResp.setResult(Boolean.TRUE);
        subscribeResp.setReturnCode("200");
        subscribeResp.setMessage("成功");
        return subscribeResp;
    }

}
