package com.bxm.shopping.web.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.shopping.common.utils.CheckUtil;
import com.bxm.shopping.dal.entity.Mold;
import com.bxm.shopping.model.ValidateGroups;
import com.bxm.shopping.model.dto.MoldDto;
import com.bxm.shopping.model.dto.MoldSearchDto;
import com.bxm.shopping.model.vo.MoldVo;
import com.bxm.shopping.service.IMoldService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 页面模板 前端控制器
 * </p>
 *
 * @author tangxiao
 * @since 2022-07-28
 */
@RestController
@RequestMapping("/mold")
public class MoldController {

    @Autowired
    private IMoldService moldService;


    @GetMapping("/page")
    public ResponseModel<IPage<MoldVo>> page(MoldSearchDto moldSearchDto) {
        IPage<MoldVo> page = moldService.page(moldSearchDto);
        return ResponseModelFactory.SUCCESS(page);
    }

    @PostMapping("/create")
    public ResponseModel create(@RequestBody @Validated(ValidateGroups.Add.class) MoldDto moldDto) {
        checkParam(moldDto);
        moldService.create(moldDto);
        return ResponseModelFactory.SUCCESS();
    }

    @PostMapping("/update")
    public ResponseModel update(@RequestBody @Validated(ValidateGroups.Update.class) MoldDto moldDto) {
        checkParam(moldDto);
        moldService.update(moldDto);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping("/getById")
    public ResponseModel getById(@RequestParam("id") Integer id) {
        Mold mold = moldService.getById(id);
        return ResponseModelFactory.SUCCESS(mold);
    }

    @GetMapping("/delete")
    public ResponseModel delete(@RequestParam("id") Integer id) {
        moldService.delete(id);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping("/updateStatus")
    public ResponseModel updateStatus(@RequestParam("id")Integer id, @RequestParam("status") Integer status) {
        moldService.updateStatus(id, status);
        return ResponseModelFactory.SUCCESS();
    }


    private void checkParam(MoldDto moldDto) {
        String moldConfig = moldDto.getConfig();
        CheckUtil.conditionCheck(StringUtils.isNotBlank(moldConfig), "config不能为空");
        List<Mold.MoldConfig> moldConfigs = JSONObject.parseArray(moldConfig, Mold.MoldConfig.class);
        for (Mold.MoldConfig config : moldConfigs) {
            CheckUtil.conditionCheck(StringUtils.isNotBlank(config.getSceneName()), "sceneName不能为空");
            CheckUtil.conditionCheck(StringUtils.isNotBlank(config.getSceneCoverImg()), "sceneCoverImg不能为空");
            CheckUtil.conditionCheck(Objects.nonNull(config.getSceneConfig()), "sceneConfig不能为空");
            for (Mold.SceneConfig sceneConfig : config.getSceneConfig()) {
                CheckUtil.conditionCheck(Objects.nonNull(sceneConfig.getType()), "type不能为空");
                CheckUtil.conditionCheck(Objects.nonNull(sceneConfig.getIsRequired()), "isRequired不能为空");
                CheckUtil.conditionCheck(Objects.nonNull(sceneConfig.getDescription()), "description不能为空");

            }

        }
    }




}

