package com.bxm.shopping.web.controller;

import com.bxm.shopping.dal.entity.Payment;
import com.bxm.shopping.dal.entity.UserOrder;
import com.bxm.shopping.service.IPaymentService;
import com.bxm.shopping.service.IUserOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 过期了，请使用shopping-api的接口
 * @author tangx
 * @date 2021/4/26 15:32
 */
@Slf4j
@RestController
@Deprecated
public class OrderCallbackController {

    @Autowired
    private IUserOrderService userOrderService;
    @Autowired
    private IPaymentService paymentService;

    /**
     * pay项目支付成功后调用这个接口来更新订单信息
     * @param orderNum
     */
    @PostMapping("/orderCallback")
    @Deprecated
    public void orderCallback(@RequestParam("orderNum") String orderNum, @RequestParam(value = "tradeNum", required = false) String tradeNum) {

        log.info("支付成功通知,更新订单状态,orderNum:{}", orderNum);

        // 订单是否存在
        UserOrder order = userOrderService.findOneByOneParamWithNotNull(UserOrder.ORDER_NUM, orderNum);
        Payment payment = paymentService.findOneByOneParamWithNotNull(Payment.ORDER_NUM, orderNum);

        if (Payment.PAY_STATUS_FINISH.equals(payment.getPayStatus())) {
            log.warn("pay请求回调时,订单是支付完成状态！ orderNum: {}", orderNum);
        }

        Payment paymentUpdate = new Payment();
        paymentUpdate.setId(payment.getId());
        paymentUpdate.setPayStatus(Payment.PAY_STATUS_FINISH);

        paymentUpdate.setCompleteTime(new Date());
        paymentUpdate.setPayNum(tradeNum);
        paymentService.updateById(paymentUpdate);
    }
}
