package com.bxm.shopping.web.controller;


import com.bxm.shopping.common.generator.RedisLockGenerator;
import com.bxm.shopping.model.dto.PlatformConfigDto;
import com.bxm.shopping.model.vo.PlatformConfigVo;
import com.bxm.shopping.service.IPlatformConfigService;
import com.bxm.warcar.cache.impls.redis.DistributedRedisLock;
import com.bxm.warcar.utils.UUIDHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 第三方效果监控配置
 * @author tangxiao
 * @since 2020-09-02
 */
@RestController
@RequestMapping("/platformConfig")
public class PlatformConfigController {

    @Autowired
    private IPlatformConfigService platformConfigService;

    @Autowired
    private DistributedRedisLock distributedRedisLock;

    /**
     * 获取配置
     * @param advertiserId
     * @return org.springframework.http.ResponseEntity
     * @author tangx
     * @DATE 2020/9/2 17:45
     */
    @GetMapping(value = "/getByAdvertiserId", produces = "application/json")
    public ResponseEntity getByAdvertiserId(@RequestParam("advertiserId") Integer advertiserId) {
        PlatformConfigVo vo = platformConfigService.getByAdvertiserId(advertiserId);
        return ResponseEntity.ok(vo);
    }

    /**
     * 保存/更新第三方效果监控配置
     * @param dto
     * @return org.springframework.http.ResponseEntity
     * @author tangx
     * @DATE 2020/9/2 17:45
     */
    @PostMapping(value = "/savePlatformConfig")
    public ResponseEntity savePlatformConfig(@Validated PlatformConfigDto dto) {
        String rid = UUIDHelper.generate();
        boolean tryLock = false;

        try {
            tryLock = distributedRedisLock.tryLock(RedisLockGenerator.getPlatformConfigSave(dto.getAdvertiserId()).generateKey(), rid);
            if (!tryLock) {
                return ResponseEntity.ok("true");
            }
            platformConfigService.savePlatformConfig(dto);
        } catch (Exception e) {
        } finally {
            if (tryLock) {
                distributedRedisLock.unLock(RedisLockGenerator.getPlatformConfigSave(dto.getAdvertiserId()).generateKey(), rid);
            }
        }
        return ResponseEntity.ok("true");
    }
}

