package com.bxm.shopping.web.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.shopping.common.utils.CheckUtil;
import com.bxm.shopping.dal.entity.Mold;
import com.bxm.shopping.dal.entity.ProductComponent;
import com.bxm.shopping.model.ValidateGroups;
import com.bxm.shopping.model.dto.ProductComponentDto;
import com.bxm.shopping.model.dto.ProductComponentSearchDto;
import com.bxm.shopping.model.vo.ProductComponentVo;
import com.bxm.shopping.service.IProductComponentService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 组件表 前端控制器
 * </p>
 *
 * @author tangxiao
 * @since 2022-09-20
 */
@RestController
@RequestMapping("/component")
public class ProductComponentController {

    @Autowired
    private IProductComponentService productComponentService;


    @GetMapping("/page")
    public ResponseModel<IPage<ProductComponentVo>> page(ProductComponentSearchDto productComponentSearchDto) {
        IPage<ProductComponentVo> page = productComponentService.page(productComponentSearchDto);
        return ResponseModelFactory.SUCCESS(page);
    }

    @PostMapping("/create")
    public ResponseModel create(@RequestBody @Validated(ValidateGroups.Add.class) ProductComponentDto productComponentDto) {
        checkParam(productComponentDto);
        productComponentService.create(productComponentDto);
        return ResponseModelFactory.SUCCESS();
    }

    @PostMapping("/update")
    public ResponseModel update(@RequestBody @Validated(ValidateGroups.Update.class) ProductComponentDto productComponentDto) {
        checkParam(productComponentDto);
        productComponentService.update(productComponentDto);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping("/getById")
    public ResponseModel getById(@RequestParam("id") Integer id) {
        ProductComponent productComponent = productComponentService.getById(id);
        return ResponseModelFactory.SUCCESS(productComponent);
    }

    @GetMapping("/delete")
    public ResponseModel delete(@RequestParam("id") Integer id) {
        productComponentService.delete(id);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping("/updateStatus")
    public ResponseModel updateStatus(@RequestParam("id")Integer id, @RequestParam("status") Integer status) {
        productComponentService.updateStatus(id, status);
        return ResponseModelFactory.SUCCESS();
    }


    private void checkParam(ProductComponentDto productComponentDto) {
        String config = productComponentDto.getConfig();
        CheckUtil.conditionCheck(StringUtils.isNotBlank(config), "config不能为空");
        List<Mold.SceneConfig> sceneConfigs = JSONObject.parseArray(config, Mold.SceneConfig.class);

        for (Mold.SceneConfig sceneConfig : sceneConfigs) {
            CheckUtil.conditionCheck(Objects.nonNull(sceneConfig.getType()), "type不能为空");
            CheckUtil.conditionCheck(Objects.nonNull(sceneConfig.getIsRequired()), "isRequired不能为空");
            CheckUtil.conditionCheck(Objects.nonNull(sceneConfig.getDescription()), "description不能为空");
        }
    }



    @GetMapping("/tryLock")
    public ResponseModel tryLock(@RequestParam("id") Integer id) {
        productComponentService.tryLock(id);
        return ResponseModelFactory.SUCCESS();
    }

    @GetMapping("/releaseLock")
    public ResponseModel releaseLock(@RequestParam("id") Integer id) {
        productComponentService.releaseLock(id);
        return ResponseModelFactory.SUCCESS();
    }

}