package com.bxm.shopping.web.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.shopping.common.utils.DateUtil;
import com.bxm.shopping.dal.entity.UserOrder;
import com.bxm.shopping.service.IUserOrderService;
import com.bxm.shopping.service.impl.UserOrderServiceImpl;
import com.bxm.shopping.service.redis.RedisKeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 用于定时器
 * @author tangx
 * @date 2021/10/27 10:23
 */
@Slf4j
@RestController
@RequestMapping("/schedule")
public class ScheduleController {

    @Autowired
    private IUserOrderService userOrderService;
    @Autowired
    private JedisFetcher fetcher;
    @Autowired
    @Qualifier("jedisFetcherData")
    private JedisFetcher jedisFetcherData;


    /**
     * 补充空的券id、广告位id
     */
    @GetMapping("/updateEmptyAdData")
    public ResponseModel updateEmptyAdData() {
        Date startDate = DateUtil.increaseMinute(new Date(), -30);
        QueryWrapper<UserOrder> queryWrapper = new QueryWrapper<>();
        queryWrapper.gt(UserOrder.CREATE_TIME, startDate);
        List<UserOrder> totalUserOrders = userOrderService.getBaseMapper().selectList(queryWrapper);
        // 筛选出符合数据
        List<UserOrder> filterUserOrders = totalUserOrders.stream()
                .filter(u -> StringUtils.isNotBlank(u.getChannelOrderId()) && StringUtils.isBlank(u.getTicketId()))
                .collect(Collectors.toList());
        log.info("更新空ticketId数据,待处理bxmid条数：{}", filterUserOrders.size());

        List<UserOrder> updateOrders = new ArrayList<>();
        for (UserOrder userOrder : filterUserOrders) {
            String bxmId = userOrder.getChannelOrderId();
            UserOrder updateOrder = new UserOrder();
            updateOrder.setId(userOrder.getId());

            //先查新版的数据 没有再查老的
            UserOrderServiceImpl.NewTicketInfo ticketInfoNew = jedisFetcherData.fetch(RedisKeyGenerator.getTicketInfoNew(bxmId), UserOrderServiceImpl.NewTicketInfo.class);
            if(Objects.nonNull(ticketInfoNew)) {
                if (CollectionUtils.isNotEmpty(ticketInfoNew.getAdid())) {
                    updateOrder.setTicketId(ticketInfoNew.getAdid().get(0));
                }
                if (CollectionUtils.isNotEmpty(ticketInfoNew.getTagid())) {
                    updateOrder.setPositionId(ticketInfoNew.getTagid().get(0));
                }
                if (StringUtils.isNotBlank(updateOrder.getTicketId()) || StringUtils.isNotBlank(updateOrder.getPositionId())) {
                    updateOrders.add(updateOrder);
                }
                continue;
            }


            String ticketInfo = fetcher.fetch(RedisKeyGenerator.getTicketInfo(bxmId), String.class);

            if (StringUtils.isBlank(ticketInfo)) {
                continue;
            }
            String[] split = ticketInfo.split("\t");
            String appKey = split[4];
            String business = split[5];
            String ticketId = split[21];
            String businessId = business.split("-")[1];
            String positionId = appKey + "-" + businessId;

            updateOrder.setTicketId(ticketId);
            updateOrder.setPositionId(positionId);
            updateOrders.add(updateOrder);
        }

        if (CollectionUtils.isNotEmpty(updateOrders)) {
            userOrderService.updateBatchById(updateOrders);
        }
        return ResponseModelFactory.SUCCESS();
    }


}
