package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.shopping.dal.entity.Product;
import com.bxm.shopping.integration.acl.AclUserIntegration;
import com.bxm.shopping.service.IProductService;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author tangx
 * @date 2022/10/26 9:21
 */
@RestController
@Slf4j
@RequestMapping("/temp")
public class TempController {

    @Autowired
    IProductService productService;

    @Autowired
    AclUserIntegration aclUserIntegration;


    @GetMapping("/fixAeData")
    public ResponseModel transfer() {
        QueryWrapper<Product> queryWrapper = new QueryWrapper<>();
        queryWrapper.isNotNull(Product.AE);
        queryWrapper.ne(Product.STATUS, Product.STATUS_DELETED);
        List<Product> list = productService.list(queryWrapper);


        Map<String, String> idTypeCodeMap = getIdTypeCodeMap();

        if (CollectionUtils.isNotEmpty(list)) {
            for (Product product : list) {

                if (StringUtils.isBlank(product.getAe())) {
                    continue;
                }

                String typeCode = idTypeCodeMap.getOrDefault(product.getAe(), product.getAe());

                Product forInset = new Product();
                forInset.setId(product.getId());
                forInset.setAe(typeCode);
                boolean b = productService.updateById(forInset);
                log.info("ae change to {}, success: {}", typeCode, b);
            }
        }
        return ResponseModelFactory.SUCCESS();
    }

    @Data
    public static class Res {
        private String id;
        private String typecode;
        private String typename;
    }


    Map<String, String> getIdTypeCodeMap() {
        RestTemplate restTemplate = new RestTemplate();

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Lists.newArrayList(MediaType.APPLICATION_JSON));

        MultiValueMap<String, String> map = new LinkedMultiValueMap<>();
        HttpEntity<MultiValueMap> httpEntity = new HttpEntity<>(map, headers);

        ResponseEntity<String> exchange = restTemplate.exchange("https://mgr.bianxianmao.com:18501/common/findUsersByRoleCode?roleCode=ae", HttpMethod.GET, httpEntity, String.class);
        com.bxm.acl.facade.model.ResultModel resultModel = JsonHelper.convert(exchange.getBody(), com.bxm.acl.facade.model.ResultModel.class);
        List<Res> resList = JSONObject.parseArray(JSONObject.toJSONString(resultModel.getReturnValue()), Res.class);
        Map<String, String> idTypeCodeMap = resList.stream().collect(Collectors.toMap(r -> r.getId(), r -> r.getTypecode()));
        return idTypeCodeMap;
    }
}
