package com.bxm.shopping.web.facade;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.shopping.facade.model.landingpage.ProductDTO;
import com.bxm.shopping.facade.model.landingpage.ProductPageQueryDTO;
import com.bxm.shopping.facade.service.ProductFacadeService;
import com.bxm.shopping.model.query.ProductQuery;
import com.bxm.shopping.model.vo.ProductVo;
import com.bxm.shopping.service.IProductService;
import com.bxm.shopping.service.util.PageUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zhangdong
 * @date 2023/2/21
 */
@RestController
public class ProductFacadeServiceImpl implements ProductFacadeService {

    private final IProductService productService;

    public ProductFacadeServiceImpl(IProductService productService) {
        this.productService = productService;
    }

    @Override
    public Page<ProductDTO> pageQuery(ProductPageQueryDTO dto) {
        ProductQuery query = new ProductQuery();
        BeanUtils.copyProperties(dto, query);
        query.setAdvertiserId(dto.getAdvertiserId() != null ? dto.getAdvertiserId().toString() : null);
        Page<ProductVo> page = productService.getPage(query);
        return PageUtil.convertPage(page, ProductDTO.class);
    }

    @Override
    public ProductDTO queryById(Integer id) {
        ProductVo vo = productService.findById(id);
        ProductDTO dto = new ProductDTO();
        if (vo == null) {
            return null;
        }
        BeanUtils.copyProperties(vo, dto);
        return dto;
    }
}
