package com.bxm.shopping.web.generator;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;

/**
 * @author 拉拉
 * @version v1.0.0
 * @fileName com.lhd.mallbook.web.generator.CodeGenerator.java
 * @created 2019-12-27 12:10:00
 * @modifier 拉拉
 * @updated 2019-12-27 12:10:00
 */
public class MybatisPlusCode {


    public static void main(String[] args) {
        AutoGenerator mpg = new AutoGenerator();

        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        //gc.setOutputDir("/Users/xiongwu/Documents/workspace/mallbook/mallbook-dal/src/main/java/");//输出文件路径
//        gc.setOutputDir("/Users/dailala/Documents/git/shopping/shopping-dal/src/main/java/");//输出文件路径
        gc.setOutputDir("/Users/team/Desktop/mybatis-generator");//输出文件路径

        gc.setFileOverride(true);
        gc.setActiveRecord(false);// 不需要ActiveRecord特性的请改为false
        gc.setEnableCache(false);// XML 二级缓存
        gc.setBaseResultMap(true);// XML ResultMap
        gc.setBaseColumnList(false);// XML columList
//        gc.setAuthor("lala");// 作者
        gc.setAuthor("tangxiao");// 作者

        // 自定义文件命名，注意 %s 会自动填充表实体属性！
        //gc.setControllerName("%sController");
        //gc.setServiceName("%sService");
        //gc.setServiceImplName("%sServiceImpl");
        gc.setMapperName("%sMapper");
        gc.setXmlName("%sMapper");
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(DbType.MYSQL);
        dsc.setDriverName("com.mysql.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("root_pwd");
        dsc.setUrl("jdbc:mysql://47.97.189.222:3309/shopping?useSSL=false&useUnicode=true&characterEncoding=utf-8&allowMultiQueries=true&autoReconnect=true");
        mpg.setDataSource(dsc);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        // strategy.setTablePrefix(new String[] { "sys_" });// 此处可以修改为您的表前缀
        strategy.setNaming(NamingStrategy.underline_to_camel);// 表名生成策略
        strategy.setInclude(
                "product",
                "product_adaptation",
                "page_type",
                "payment",
                "product_adaptation",
                "product_rules",
                "agreement",
                "mold",
                "product_component",
                "user",
                "page"
        ); // 需要生成的表
        strategy.setEntityColumnConstant(true);

     /*   strategy.setSuperServiceClass(null);
        strategy.setSuperServiceImplClass(null);*/
        strategy.setSuperMapperClass(null);

        mpg.setStrategy(strategy);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setParent("com.bxm.shopping.dal");/*
        pc.setController("controller");
        pc.setService("service");
        pc.setServiceImpl("service.impl");*/
        pc.setMapper("mapper");
        pc.setEntity("entity");
        gc.setDateType(DateType.ONLY_DATE);

        pc.setXml("xml");
        mpg.setPackageInfo(pc);

        // 执行生成
        mpg.execute();

    }

}
