package com.bxm.shopping.web.global;

import com.bxm.shopping.common.exception.BusinessException;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;


@Slf4j
@ControllerAdvice
public class GlobalExceptionHandler {

    @ExceptionHandler(UnsupportedOperationException.class)
    @ResponseBody
    public ResponseModel<String> unsupportedOperation() {
        return ResponseModelFactory.FAILED400();
    }

    @ExceptionHandler(IllegalStateException.class)
    @ResponseBody
    public ResponseModel<String> illegalStateException(Throwable throwable) {
        return ResponseModelFactory.FAILED400();
    }

    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseBody
    public ResponseModel<String> illegalArgument(Throwable throwable) {
        return ResponseModelFactory.FAILED(HttpStatus.BAD_REQUEST.value(), throwable.getMessage());
    }

    @ExceptionHandler(HttpRequestMethodNotSupportedException.class)
    @ResponseBody
    public ResponseModel HttpRequestMethodNotSupportedException(Throwable throwable) {
        return ResponseModelFactory.FAILED(HttpStatus.BAD_REQUEST.value(), throwable.getMessage());
    }

    @ExceptionHandler(MissingServletRequestParameterException.class)
    @ResponseBody
    public ResponseModel missingServletRequestParameterException(Throwable throwable) {
        return ResponseModelFactory.FAILED(HttpStatus.BAD_REQUEST.value(), throwable.getMessage());
    }


    @ExceptionHandler(ValidateException.class)
    @ResponseBody
    public ResponseModel ValidateException(Throwable throwable) {
        return ResponseModelFactory.FAILED(HttpStatus.BAD_REQUEST.value(), throwable.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(HttpMessageNotReadableException.class)
    public ResponseModel<String> HttpMessageNotReadableException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED(400, "请填写正确的参数");
    }

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public ResponseModel exception(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED500("服务器错误");
    }

    @ExceptionHandler(BusinessException.class)
    @ResponseBody
    public ResponseModel businessException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        return ResponseModelFactory.FAILED500(throwable.getMessage());
    }
    @ExceptionHandler({BindException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseModel BindException(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        String[] msg = throwable.getMessage().split(";");
        String finalmsg = msg[msg.length - 1].replace("default", "")
                .replace("message", "")
                .replace("[", "").replace("]", "").replace(" ", "");
        return ResponseModelFactory.FAILED(HttpStatus.BAD_REQUEST.value(), finalmsg);
    }

    @ExceptionHandler(value = {ShoppingException.class})
    @ResponseBody
    public ResponseModel handleGatherException(Exception e) {
        return ResponseModelFactory.FAILED500(e.getMessage());
    }

}
