package com.bxm.shopping.web.interceptor;

import com.bxm.acl.facade.AclAuthInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;


@Configuration
public class InterceptorConfigurer extends WebMvcConfigurerAdapter {


    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 多个拦截器组成一个拦截器链
        // addPathPatterns 用于添加拦截规则
        registry.addInterceptor(aclAuthInterceptor()).addPathPatterns("/*/**")
                .excludePathPatterns("/template/**",
                        "/upload/*",
                        "/kuaidi/callback",
                        "/orderCallback",
                        "/addressTransfer",
                        "/address/init",
                        "/schedule/**",
                        "/temp/*",
                        "/facade/**",
                        "/product/**",
                        "/product/sync/**");
        super.addInterceptors(registry);
    }

    @Bean
    public AclAuthInterceptor aclAuthInterceptor() {
        return new AclAuthInterceptor(32);
    }
}
