/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
public class AddressExcelListProcessor {
    private static final Logger log = LoggerFactory.getLogger(AddressExcelListProcessor.class);

    public static List<Province> transformAddressTree(List<ImportVo> importVos) {
        Map provinceMap = importVos.stream().collect(Collectors.groupingBy(i -> i.getProvinceName(), LinkedHashMap::new, Collectors.toList()));
        ArrayList<Province> resultList = new ArrayList<Province>(50);
        provinceMap.forEach((k, v) -> {
            Map cityMap = v.stream().collect(Collectors.groupingBy(i -> i.getCityName(), LinkedHashMap::new, Collectors.toList()));
            Province provinceData = new Province();
            provinceData.setName((String)k);
            ArrayList<City> cityResult = new ArrayList<City>();
            cityMap.forEach((cityName, i) -> {
                City cityData = new City();
                cityData.setName((String)cityName);
                List regionimportVos = (List)cityMap.get(cityName);
                ArrayList<Region> regionResult = new ArrayList<Region>();
                for (ImportVo regionimportVo : regionimportVos) {
                    Region regionData = new Region();
                    regionData.setName(regionimportVo.getRegionName());
                    regionResult.add(regionData);
                }
                cityData.setChildren(regionResult);
                cityResult.add(cityData);
            });
            provinceData.setChildren(cityResult);
            resultList.add(provinceData);
        });
        return resultList;
    }

    public static class Region
    implements Serializable {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Region)) {
                return false;
            }
            Region other = (Region)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Region;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "AddressExcelListProcessor.Region(name=" + this.getName() + ")";
        }
    }

    public static class City
    implements Serializable {
        @JSONField(ordinal=1)
        private String name;
        @JSONField(ordinal=2)
        private List<Region> children;

        public String getName() {
            return this.name;
        }

        public List<Region> getChildren() {
            return this.children;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setChildren(List<Region> children) {
            this.children = children;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof City)) {
                return false;
            }
            City other = (City)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Region> this$children = this.getChildren();
            List<Region> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        protected boolean canEqual(Object other) {
            return other instanceof City;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Region> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String toString() {
            return "AddressExcelListProcessor.City(name=" + this.getName() + ", children=" + this.getChildren() + ")";
        }
    }

    public static class Province
    implements Serializable {
        @JSONField(ordinal=1)
        private String name;
        @JSONField(ordinal=2)
        private List<City> children;

        public String getName() {
            return this.name;
        }

        public List<City> getChildren() {
            return this.children;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setChildren(List<City> children) {
            this.children = children;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Province)) {
                return false;
            }
            Province other = (Province)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<City> this$children = this.getChildren();
            List<City> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Province;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<City> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String toString() {
            return "AddressExcelListProcessor.Province(name=" + this.getName() + ", children=" + this.getChildren() + ")";
        }
    }

    public static class ImportVo
    implements Serializable {
        private static final long serialVersionUID = -8923767200269229961L;
        @ExcelProperty(value={"\u7701"})
        private String provinceName;
        @ExcelProperty(value={"\u5e02"})
        private String cityName;
        @ExcelProperty(value={"\u533a/\u53bf"})
        private String regionName;

        public String getProvinceName() {
            return this.provinceName;
        }

        public String getCityName() {
            return this.cityName;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public void setProvinceName(String provinceName) {
            this.provinceName = provinceName;
        }

        public void setCityName(String cityName) {
            this.cityName = cityName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportVo)) {
                return false;
            }
            ImportVo other = (ImportVo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$provinceName = this.getProvinceName();
            String other$provinceName = other.getProvinceName();
            if (this$provinceName == null ? other$provinceName != null : !this$provinceName.equals(other$provinceName)) {
                return false;
            }
            String this$cityName = this.getCityName();
            String other$cityName = other.getCityName();
            if (this$cityName == null ? other$cityName != null : !this$cityName.equals(other$cityName)) {
                return false;
            }
            String this$regionName = this.getRegionName();
            String other$regionName = other.getRegionName();
            return !(this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImportVo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $provinceName = this.getProvinceName();
            result = result * 59 + ($provinceName == null ? 43 : $provinceName.hashCode());
            String $cityName = this.getCityName();
            result = result * 59 + ($cityName == null ? 43 : $cityName.hashCode());
            String $regionName = this.getRegionName();
            result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
            return result;
        }

        public String toString() {
            return "AddressExcelListProcessor.ImportVo(provinceName=" + this.getProvinceName() + ", cityName=" + this.getCityName() + ", regionName=" + this.getRegionName() + ")";
        }
    }
}

