/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.dal.entity.Agreement;
import com.bxm.shopping.model.ValidateGroups;
import com.bxm.shopping.model.dto.AgreementDto;
import com.bxm.shopping.model.dto.AgreementSearchDto;
import com.bxm.shopping.service.IAgreementService;
import com.bxm.shopping.service.util.RequestUtils;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agreement"})
public class AgreementController {
    @Autowired
    private IAgreementService agreementService;

    @GetMapping(value={"/list"})
    public ResponseModel list(AgreementSearchDto searchDto) {
        IPage list = this.agreementService.list(searchDto);
        return ResponseModelFactory.SUCCESS((Object)list);
    }

    @GetMapping(value={"/listSimple"})
    public ResponseModel listSimple(AgreementSearchDto searchDto) {
        return ResponseModelFactory.SUCCESS((Object)this.agreementService.listSimple(searchDto));
    }

    @GetMapping(value={"/get"})
    public ResponseModel getById(@RequestParam(value="id") Integer id) {
        return ResponseModelFactory.SUCCESS((Object)this.agreementService.getById((Serializable)id));
    }

    @PostMapping(value={"/create"})
    public ResponseModel create(@RequestBody @Validated(value={ValidateGroups.Add.class}) AgreementDto agreementDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(Agreement::getName, (Object)agreementDto.getName())).eq(Agreement::getAdvertiserId, (Object)agreementDto.getAdvertiserId());
        if (this.agreementService.count((Wrapper)queryWrapper) > 0) {
            throw new ShoppingException("\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Agreement agreement = new Agreement();
        BeanUtils.copyProperties((Object)agreementDto, (Object)agreement);
        agreement.setCreateTime(new Date());
        agreement.setCreateUser(RequestUtils.getCurrentUserName());
        agreement.setUpdateTime(new Date());
        this.agreementService.save((Object)agreement);
        return ResponseModelFactory.SUCCESS();
    }

    @PostMapping(value={"/update"})
    public ResponseModel update(@RequestBody @Validated(value={ValidateGroups.Update.class}) AgreementDto agreementDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(Agreement::getName, (Object)agreementDto.getName())).eq(Agreement::getAdvertiserId, (Object)agreementDto.getAdvertiserId())).ne(Agreement::getId, (Object)agreementDto.getId());
        if (this.agreementService.count((Wrapper)queryWrapper) > 0) {
            throw new ShoppingException("\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Agreement agreement = new Agreement();
        BeanUtils.copyProperties((Object)agreementDto, (Object)agreement);
        agreement.setUpdateTime(new Date());
        agreement.setUpdateUser(RequestUtils.getCurrentUserName());
        this.agreementService.updateById((Object)agreement);
        return ResponseModelFactory.SUCCESS();
    }
}

