/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.bxm.shopping.common.enums.FileType;
import com.bxm.shopping.common.exception.ShoppingException;
import com.bxm.shopping.common.utils.FileTypeJudge;
import com.bxm.shopping.common.utils.InputStreamUtil;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@RestController
@RequestMapping(value={"/upload"})
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    private String bucketName = "bxm-guide";
    private String fileHost = "https://buyimg.bianxianmao.com/";
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";
    private static final Set<String> ALLOW_IMG_TYPE_SET = Sets.newHashSet((Object[])new String[]{FileType.JPG.getCode(), FileType.PNG.getCode(), FileType.GIF.getCode()});
    private static final long MAX_UPLOAD_IMG_SIZE = 0x300000L;
    @Autowired
    private HttpFileManager httpFileManager;
    private static final ExecutorService SINGLE_THREAD_POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("upload-img"));

    @PreDestroy
    public void destroy() {
        SINGLE_THREAD_POOL.shutdown();
        try {
            if (!SINGLE_THREAD_POOL.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.error("termination has timeout");
            }
        }
        catch (InterruptedException e) {
            log.error("destroy:", (Throwable)e);
        }
    }

    @RequestMapping(value={"/img"}, method={RequestMethod.POST})
    public String uploadImg(@RequestParam(value="img") MultipartFile file) throws Exception {
        String uploadPath;
        if (file.isEmpty()) {
            throw new ShoppingException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (file.getSize() > 0x300000L) {
            throw new ShoppingException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e3M\uff01");
        }
        FileType fileType = FileTypeJudge.getTypeByInputStream((InputStream)InputStreamUtil.copy((InputStream)file.getInputStream()));
        if (null == fileType || !ALLOW_IMG_TYPE_SET.contains(fileType.getCode())) {
            throw new ShoppingException("\u8bf7\u4e0a\u4f20\u6b63\u786e\u7c7b\u578b\u7684\u6587\u4ef6\uff01");
        }
        Future<String> future = SINGLE_THREAD_POOL.submit(() -> {
            try {
                return this.httpFileManager.upload(new HttpFileRequest(file));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ShoppingException("\u4e0a\u4f20\u5931\u8d25");
            }
        });
        try {
            uploadPath = future.get(6L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new ShoppingException("\u4e0a\u4f20\u8d85\u65f6");
        }
        catch (Exception e) {
            future.cancel(true);
            throw new ShoppingException("\u4e0a\u4f20\u5931\u8d25");
        }
        log.info("img upload success, the url : {} ", (Object)uploadPath);
        return uploadPath;
    }

    @RequestMapping(value={"/video"}, method={RequestMethod.POST})
    public ResultModel<List<String>> uploadVideo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultModel resultModel = new ResultModel();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> files = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String fileName;
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null || (fileName = file.getOriginalFilename()).trim() == "") continue;
                File newFile = new File(fileName);
                FileOutputStream outStream = new FileOutputStream(newFile);
                outStream.write(file.getBytes());
                outStream.close();
                file.transferTo(newFile);
                files.add(AliOSSUtil.upload((String)this.accessKeyId, (String)this.secret, (File)newFile, (String)this.bucketName, (String)this.fileHost, null));
                newFile.delete();
            }
        }
        if (files.isEmpty()) {
            resultModel.setErrorDesc("\u7cfb\u7edf\u5f02\u5e38,\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            resultModel.setReturnValue(null);
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(files);
        log.info("file upload success! url:{}", files.get(0));
        return resultModel;
    }
}

