/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopping.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shopping.common.enums.OrderType;
import com.bxm.shopping.common.enums.TrackStatusEnum;
import com.bxm.shopping.dal.entity.UserOrder;
import com.bxm.shopping.integration.kuaidi.model.SubscribeResp;
import com.bxm.shopping.integration.kuaidi.model.TrackInfoVo;
import com.bxm.shopping.integration.kuaidi.utils.SignUtils;
import com.bxm.shopping.service.IUserOrderService;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class KuaidiController {
    private static final Logger log = LoggerFactory.getLogger(KuaidiController.class);
    @Resource
    IUserOrderService orderService;

    @RequestMapping(value={"/order/getTrackInfo"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity getTrackInfo(@RequestParam(value="id") Integer id) {
        TrackInfoVo vo = this.orderService.getTrackInfo(id);
        return ResponseEntity.ok((Object)vo);
    }

    @RequestMapping(value={"/kuaidi/callback"}, method={RequestMethod.POST})
    public SubscribeResp callback(HttpServletRequest request) {
        String param = request.getParameter("param");
        String sign = request.getParameter("sign");
        String orderNum = request.getParameter("orderNum");
        String trackingNum = request.getParameter("trackingNum");
        log.info("\u3010\u5feb\u9012100\u3011\u8ba2\u9605\u63a8\u9001\u6570\u636e|{}|{}|{}", new Object[]{param, sign, orderNum});
        String ourSign = SignUtils.sign((String)(param + "bxm"));
        if (!ourSign.equals(sign)) {
            return null;
        }
        JSONObject paramJson = (JSONObject)JsonHelper.convert((String)param, JSONObject.class);
        JSONObject lastResult = (JSONObject)paramJson.get((Object)"lastResult");
        String state = StringUtil.toString((Object)lastResult.get((Object)"state"));
        if (StringUtils.isBlank((String)state)) {
            return null;
        }
        List userOrdersByTrackingNum = this.orderService.findListByOneParam("tracking_num", (Object)trackingNum);
        if (CollectionUtils.isEmpty((Collection)userOrdersByTrackingNum)) {
            log.warn("\u3010\u5feb\u9012100\u3011\u8ba2\u9605\u63a8\u9001\u56de\u8c03\u7684\u5feb\u9012\u5355\u53f7\u6709\u8bef,orderNum:{}\uff0ctrackingNum:{}", (Object)orderNum, (Object)trackingNum);
            return this.successReturn();
        }
        for (UserOrder order : userOrdersByTrackingNum) {
            if (!order.getStatus().equals(OrderType.THREE.getCode())) continue;
            if (state.equals(TrackStatusEnum.QIANSHOU.getCode()) || state.equals(TrackStatusEnum.ZHUANDAN.getCode())) {
                this.orderService.updateStatus(order.getId(), OrderType.FOUR.getCode());
                log.info("\u3010\u5feb\u9012100\u3011\u8ba2\u9605\u56de\u8c03\u7ed3\u679c\uff1a\u8ba2\u5355\u66f4\u65b0\u4e3a\u4ea4\u6613\u6210\u529f, orderNum: {}", (Object)orderNum);
            }
            if (!state.equals(TrackStatusEnum.TUIQIAN.getCode()) && !state.equals(TrackStatusEnum.JUQIAN.getCode())) continue;
            this.orderService.updateStatus(order.getId(), OrderType.FIVE.getCode());
            log.info("\u3010\u5feb\u9012100\u3011\u8ba2\u9605\u56de\u8c03\u7ed3\u679c\uff1a\u8ba2\u5355\u66f4\u65b0\u4e3a\u4ea4\u6613\u5931\u8d25, orderNum: {}", (Object)orderNum);
        }
        return this.successReturn();
    }

    public SubscribeResp successReturn() {
        SubscribeResp subscribeResp = new SubscribeResp();
        subscribeResp.setResult(Boolean.TRUE.booleanValue());
        subscribeResp.setReturnCode("200");
        subscribeResp.setMessage("\u6210\u529f");
        return subscribeResp;
    }
}

